/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectInfo {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectInfo.class);
    public static final int RENAME_NO = 0;
    public static final int RENAME_REQUIRED = 2;
    private final String label;
    private File pomFile;
    private Model model;
    private final MavenProjectInfo parent;
    private final Map<String, MavenProjectInfo> projects = new LinkedHashMap<String, MavenProjectInfo>();
    private final Set<String> profiles = new HashSet<String>();
    private int basedirRename = 0;

    public MavenProjectInfo(String label, File pomFile, Model model, MavenProjectInfo parent) {
        this.label = label;
        this.pomFile = pomFile;
        this.model = model;
        this.parent = parent;
    }

    public void setPomFile(File pomFile) {
        File oldDir = this.pomFile.getParentFile();
        File newDir = pomFile.getParentFile();
        for (MavenProjectInfo projectInfo : this.projects.values()) {
            File childPom = projectInfo.getPomFile();
            if (!this.isSubDir(oldDir, childPom.getParentFile())) continue;
            String oldPath = oldDir.getAbsolutePath();
            String path = childPom.getAbsolutePath().substring(oldPath.length());
            projectInfo.setPomFile(new File(newDir, path));
        }
        this.pomFile = pomFile;
    }

    public void setNeedsRename(boolean needsRename) {
        this.setBasedirRename(needsRename ? 2 : 0);
    }

    public boolean isNeedsRename() {
        return this.getBasedirRename() == 2;
    }

    public void setBasedirRename(int basedirRename) {
        this.basedirRename = basedirRename;
    }

    public int getBasedirRename() {
        return this.basedirRename;
    }

    private boolean isSubDir(File parentDir, File subDir) {
        if (parentDir.equals(subDir)) {
            return true;
        }
        if (subDir.getParentFile() != null) {
            return this.isSubDir(parentDir, subDir.getParentFile());
        }
        return false;
    }

    public void add(MavenProjectInfo info) {
        String key;
        try {
            key = info.getPomFile() == null ? info.getLabel() : info.getPomFile().getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        MavenProjectInfo i = this.projects.get(key);
        if (i == null) {
            this.projects.put(key, info);
        } else {
            log.error("Project info " + this + " already has a child project info with key '" + key + "'");
            Iterator<String> it = info.getProfiles().iterator();
            while (it.hasNext()) {
                i.addProfile(it.next());
            }
        }
    }

    public void addProfile(String profileId) {
        if (profileId != null) {
            this.profiles.add(profileId);
        }
    }

    public void addProfiles(Collection<String> profiles) {
        this.profiles.addAll(profiles);
    }

    public String getLabel() {
        return this.label;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Collection<MavenProjectInfo> getProjects() {
        return this.projects.values();
    }

    public MavenProjectInfo getParent() {
        return this.parent;
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MavenProjectInfo) {
            MavenProjectInfo info = (MavenProjectInfo)obj;
            if (this.pomFile == null) {
                return info.getPomFile() == null;
            }
            return this.pomFile.equals(info.getPomFile());
        }
        return false;
    }

    public int hashCode() {
        return this.pomFile == null ? 0 : this.pomFile.hashCode();
    }

    public String toString() {
        return "'" + this.label + "'" + (this.pomFile == null ? "" : " " + this.pomFile.getAbsolutePath());
    }
}

