/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.net.http;

import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.net.http.CommonHttpClient3;
import org.eclipse.mylyn.commons.net.http.CommonHttpMethod3;
import org.eclipse.mylyn.internal.commons.net.http.CommonGetMethod3;
import org.eclipse.mylyn.internal.commons.net.http.CommonHeadMethod3;
import org.eclipse.mylyn.internal.commons.net.http.CommonPostMethod3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpOperation3<T> {
    private final CommonHttpClient3 client;

    public HttpOperation3(CommonHttpClient3 client) {
        this.client = client;
    }

    protected CommonHttpMethod3 createGetMethod(String requestPath) {
        return new CommonGetMethod3(requestPath);
    }

    protected CommonHttpMethod3 createPostMethod(String requestPath) {
        return new CommonPostMethod3(requestPath);
    }

    protected CommonHttpMethod3 createHeadMethod(String requestPath) {
        return new CommonHeadMethod3(requestPath);
    }

    protected int execute(HttpMethod method, IOperationMonitor monitor) throws IOException {
        int code;
        monitor = OperationUtil.convert((IProgressMonitor)monitor);
        if (this.needsAuthentication()) {
            this.client.authenticate(monitor);
        }
        if (this.needsReauthentication(code = this.executeInternal(method, monitor), monitor)) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            this.client.authenticate(monitor);
            return this.executeInternal(method, monitor);
        }
        return code;
    }

    private int executeInternal(HttpMethod method, IOperationMonitor monitor) throws IOException {
        int code;
        try {
            code = WebUtil.execute(this.client.getHttpClient(), this.client.getHostConfiguration(monitor), method, (IProgressMonitor)monitor);
        }
        catch (IOException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
        catch (RuntimeException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
        return code;
    }

    protected final CommonHttpClient3 getClient() {
        return this.client;
    }

    protected boolean hasCredentials(AuthenticationCredentials credentials) {
        return credentials != null;
    }

    protected boolean needsAuthentication() {
        return false;
    }

    private boolean needsReauthentication(int code, IOperationMonitor monitor) throws IOException {
        return this.client.needsReauthentication(code, (IProgressMonitor)monitor);
    }
}

