/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;

public class RepositoryLocationValueProperty
extends SimpleValueProperty {
    private final String key;
    private final String defaultValue;

    public RepositoryLocationValueProperty(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public Object getValueType() {
        return String.class;
    }

    protected Object doGetValue(Object source) {
        String value = ((RepositoryLocation)source).getProperty(this.key);
        return value != null ? value : this.defaultValue;
    }

    protected void doSetValue(Object source, Object value) {
        ((RepositoryLocation)source).setProperty(this.key, value != null ? value.toString() : null);
    }

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return new PrivatePropertyChangeListener((IProperty)this, listener);
    }

    private class PrivatePropertyChangeListener
    extends NativePropertyListener
    implements PropertyChangeListener {
        public PrivatePropertyChangeListener(IProperty property, ISimplePropertyListener listener) {
            super(property, listener);
        }

        protected void doAddTo(Object source) {
            ((RepositoryLocation)source).addPropertyChangeListener((PropertyChangeListener)this);
        }

        protected void doRemoveFrom(Object source) {
            ((RepositoryLocation)source).removePropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || RepositoryLocationValueProperty.this.key.equals(evt.getPropertyName())) {
                Object oldValue = evt.getOldValue();
                Object newValue = evt.getNewValue();
                ValueDiff diff = evt.getPropertyName() == null || oldValue == null || newValue == null ? null : Diffs.createValueDiff((Object)oldValue, (Object)newValue);
                this.fireChange(evt.getSource(), (IDiff)diff);
            }
        }
    }
}

