/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.hudson.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.ui.BuildsUiStartup;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.hudson.ui.HudsonDiscovery;
import org.eclipse.mylyn.internal.hudson.ui.HudsonUiPlugin;

public class HudsonStartup
extends BuildsUiStartup {
    private static HudsonStartup instance;
    private HudsonDiscovery discovery;

    public static HudsonStartup getInstance() {
        return instance;
    }

    public HudsonStartup() {
        instance = this;
    }

    public void lazyStartup() {
        if (this.discovery != null) {
            throw new IllegalStateException("Already started");
        }
        try {
            this.discovery = new HudsonDiscovery();
            this.discovery.start();
        }
        catch (LinkageError e) {
            StatusHandler.log((IStatus)new Status(2, HudsonUiPlugin.ID_PLUGIN, "ECF integration failed to load. Hudson server auto discovery is not available.", (Throwable)e));
            this.discovery = null;
        }
    }

    public void stop() {
        if (this.discovery != null) {
            try {
                this.discovery.stop();
            }
            catch (NullPointerException nullPointerException) {}
            this.discovery = null;
        }
    }
}

