/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.oslc.core.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.oslc.core.IOslcCoreConstants;
import org.eclipse.mylyn.internal.oslc.core.OslcCreationDialogDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcSelectionDialogDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceFactory;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProvider;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProviderCatalog;
import org.eclipse.mylyn.internal.oslc.core.ServiceHome;
import org.eclipse.mylyn.internal.oslc.core.cm.AbstractChangeRequest;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOslcClient {
    private static final String UTF_8 = "UTF-8";
    protected final AbstractWebLocation location;
    protected final HttpClient httpClient;
    protected final OslcServiceDescriptor configuration;

    public AbstractOslcClient(AbstractWebLocation location, OslcServiceDescriptor data) {
        this.location = location;
        this.httpClient = this.createHttpClient();
        this.configuration = data;
        this.configureHttpCredentials(location);
    }

    protected void configureHttpCredentials(AbstractWebLocation location) {
        AuthScope authScope = new AuthScope(WebUtil.getHost((String)location.getUrl()), WebUtil.getPort((String)location.getUrl()), null, AuthScope.ANY_SCHEME);
        AuthenticationCredentials credentials = location.getCredentials(AuthenticationType.REPOSITORY);
        if (this.credentialsValid(credentials)) {
            Credentials creds = WebUtil.getHttpClientCredentials((AuthenticationCredentials)credentials, (String)WebUtil.getHost((String)location.getUrl()));
            this.httpClient.getState().setCredentials(authScope, creds);
            this.httpClient.getParams().setAuthenticationPreemptive(true);
        } else {
            this.httpClient.getState().clearCredentials();
        }
    }

    protected boolean credentialsValid(AuthenticationCredentials credentials) {
        return credentials != null && credentials.getUserName().length() > 0;
    }

    protected HttpClient createHttpClient() {
        HttpClient httpClient = new HttpClient();
        httpClient.setHttpConnectionManager(WebUtil.getConnectionManager());
        httpClient.getParams().setCookiePolicy("rfc2109");
        httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        WebUtil.configureHttpClient((HttpClient)httpClient, (String)this.getUserAgent());
        return httpClient;
    }

    public abstract String getUserAgent();

    public List<OslcServiceProvider> getAvailableServices(String url, IProgressMonitor monitor) throws CoreException {
        RequestHandler<List<OslcServiceProvider>> handler = new RequestHandler<List<OslcServiceProvider>>("Requesting Available Services"){

            @Override
            public List<OslcServiceProvider> run(HttpMethodBase method, IProgressMonitor monitor) throws CoreException {
                try {
                    ArrayList<OslcServiceProvider> result = new ArrayList<OslcServiceProvider>();
                    AbstractOslcClient.this.parseServices(method.getResponseBodyAsStream(), result, monitor);
                    return result;
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network error occurred retrieving available services: " + e.getMessage(), (Throwable)e));
                }
            }
        };
        return this.executeMethod((HttpMethodBase)this.createGetMethod(url), handler, monitor);
    }

    protected Document getDocumentFromMethod(HttpMethodBase method) throws CoreException {
        try {
            return this.getDocumentFromStream(method.getResponseBodyAsStream());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network error obtaining response from server: " + e.getMessage(), (Throwable)e));
        }
    }

    protected Document getDocumentFromStream(InputStream inStream) throws CoreException {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(false);
        try {
            return builder.build(inStream);
        }
        catch (JDOMException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Error parsing response: " + e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network error parsing response: " + e.getMessage(), (Throwable)e));
        }
    }

    public void parseServices(InputStream inStream, Collection<OslcServiceProvider> providers, IProgressMonitor monitor) throws CoreException {
        Element element;
        Document doc = this.getDocumentFromStream(inStream);
        Iterator itr = doc.getDescendants((Filter)new ElementFilter("ServiceProviderCatalog"));
        while (itr.hasNext()) {
            element = (Element)itr.next();
            if (element == doc.getRootElement()) continue;
            Attribute attrAbout = element.getAttribute("about", IOslcCoreConstants.NAMESPACE_RDF);
            String title = element.getChild("title", IOslcCoreConstants.NAMESPACE_DC).getText();
            if (attrAbout == null || attrAbout.getValue().length() <= 0) continue;
            providers.add(new OslcServiceProviderCatalog(title, attrAbout.getValue()));
        }
        itr = doc.getDescendants((Filter)new ElementFilter("ServiceProvider"));
        while (itr.hasNext()) {
            element = (Element)itr.next();
            String title = element.getChild("title", IOslcCoreConstants.NAMESPACE_DC).getText();
            Element service = element.getChild("services", IOslcCoreConstants.NAMESPACE_OSLC_DISCOVERY_1_0);
            if (service == null) continue;
            String resource = service.getAttributeValue("resource", IOslcCoreConstants.NAMESPACE_RDF);
            providers.add(new OslcServiceProvider(title, resource));
        }
    }

    public OslcServiceDescriptor getServiceDescriptor(OslcServiceProvider provider, IProgressMonitor monitor) throws CoreException {
        OslcServiceDescriptor configuration = new OslcServiceDescriptor(provider.getUrl());
        this.downloadServiceDescriptor(configuration, monitor);
        return configuration;
    }

    protected void downloadServiceDescriptor(final OslcServiceDescriptor config, IProgressMonitor monitor) throws CoreException {
        RequestHandler<OslcServiceDescriptor> handler = new RequestHandler<OslcServiceDescriptor>("Retrieving Service Descriptor"){

            @Override
            public OslcServiceDescriptor run(HttpMethodBase method, IProgressMonitor monitor) throws CoreException, IOException {
                config.clear();
                AbstractOslcClient.this.parseServiceDescriptor(method.getResponseBodyAsStream(), config, monitor);
                return config;
            }
        };
        this.executeMethod((HttpMethodBase)this.createGetMethod(config.getAboutUrl()), handler, monitor);
    }

    public void parseServiceDescriptor(InputStream inStream, OslcServiceDescriptor config, IProgressMonitor monitor) throws CoreException {
        Element childUrl;
        Element childTitle;
        Element element;
        String url;
        Attribute attrDefault;
        String url2;
        Element element2;
        Element element3;
        Document doc = this.getDocumentFromStream(inStream);
        Iterator itr = doc.getDescendants((Filter)new ElementFilter("title", IOslcCoreConstants.NAMESPACE_DC));
        if (itr.hasNext()) {
            element3 = (Element)itr.next();
            config.setTitle(element3.getText());
        }
        if ((itr = doc.getDescendants((Filter)new ElementFilter("description", IOslcCoreConstants.NAMESPACE_DC))).hasNext()) {
            element3 = (Element)itr.next();
            config.setDescription(element3.getText());
        }
        itr = doc.getDescendants((Filter)new ElementFilter("creationDialog", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0));
        while (itr.hasNext()) {
            boolean isDefault = false;
            element2 = (Element)itr.next();
            String label = element2.getChild("title", IOslcCoreConstants.NAMESPACE_DC).getText();
            url2 = element2.getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0).getText();
            attrDefault = element2.getAttribute("default", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
            if (attrDefault != null && attrDefault.getValue().equals("true")) {
                isDefault = true;
            }
            OslcCreationDialogDescriptor recordType = new OslcCreationDialogDescriptor(label, url2);
            config.addCreationDialog(recordType);
            if (!isDefault) continue;
            config.setDefaultCreationDialog(recordType);
        }
        itr = doc.getDescendants((Filter)new ElementFilter("simpleQuery"));
        if (itr.hasNext() && (url = (element = (Element)itr.next()).getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0).getText()) != null) {
            config.setSimpleQueryUrl(url);
        }
        itr = doc.getDescendants((Filter)new ElementFilter("factory"));
        while (itr.hasNext()) {
            boolean isDefault = false;
            element2 = (Element)itr.next();
            String title = element2.getChild("title", IOslcCoreConstants.NAMESPACE_DC).getText();
            url2 = element2.getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0).getText();
            attrDefault = element2.getAttribute("default", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
            if (attrDefault != null && attrDefault.getValue().equals("true")) {
                isDefault = true;
            }
            OslcServiceFactory factory = new OslcServiceFactory(title, url2);
            if (isDefault) {
                config.setDefaultFactory(factory);
            }
            config.addServiceFactory(factory);
        }
        itr = doc.getDescendants((Filter)new ElementFilter("home"));
        if (itr.hasNext()) {
            element = (Element)itr.next();
            childTitle = element.getChild("title", IOslcCoreConstants.NAMESPACE_DC);
            childUrl = element.getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
            if (childTitle != null && childTitle.getText().length() > 0 && childUrl != null && childUrl.getText().length() > 0) {
                ServiceHome home = new ServiceHome(childTitle.getText(), childUrl.getText());
                config.setHome(home);
            }
        }
        if ((itr = doc.getDescendants((Filter)new ElementFilter("selectionDialog"))).hasNext()) {
            element = (Element)itr.next();
            childTitle = element.getChild("title", IOslcCoreConstants.NAMESPACE_DC);
            childUrl = element.getChild("url", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
            if (childTitle != null && childTitle.getText().length() > 0 && childUrl != null && childUrl.getText().length() > 0) {
                String label;
                String hintWidth;
                String hintHeight;
                OslcSelectionDialogDescriptor selection = new OslcSelectionDialogDescriptor(childTitle.getText(), childUrl.getText());
                String isDefault = element.getAttributeValue("default", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
                if (isDefault != null) {
                    selection.setDefault(isDefault.equals("true"));
                }
                if ((hintHeight = element.getAttributeValue("hintHeight", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0)) != null) {
                    selection.setHintHeight(hintHeight);
                }
                if ((hintWidth = element.getAttributeValue("hintWidth", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0)) != null) {
                    selection.setHintWidth(hintWidth);
                }
                if ((label = element.getChildText("label", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0)) != null) {
                    selection.setLabel(label);
                }
                config.addSelectionDialog(selection);
            }
        }
    }

    protected OslcServiceDescriptor getConfiguration(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        if (this.configuration.getFactories().isEmpty()) {
            this.updateRepositoryConfiguration((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        return this.configuration;
    }

    public Collection<AbstractChangeRequest> performQuery(String query, IProgressMonitor monitor) throws CoreException {
        try {
            query = URLEncoder.encode(query, UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            query = URLEncoder.encode(query);
        }
        String requestUrl = String.valueOf(this.getConfiguration(monitor).getSimpleQueryUrl()) + "?oslc_cm.query=" + query;
        RequestHandler<Collection<AbstractChangeRequest>> handler = new RequestHandler<Collection<AbstractChangeRequest>>("Performing Query"){

            @Override
            public Collection<AbstractChangeRequest> run(HttpMethodBase method, IProgressMonitor monitor) throws CoreException, IOException {
                ArrayList<AbstractChangeRequest> result = new ArrayList<AbstractChangeRequest>();
                AbstractOslcClient.this.parseQueryResponse(method.getResponseBodyAsStream(), result, monitor);
                return result;
            }
        };
        return this.executeMethod((HttpMethodBase)this.createGetMethod(requestUrl), handler, monitor);
    }

    public void parseQueryResponse(InputStream inStream, Collection<AbstractChangeRequest> requests, IProgressMonitor monitor) throws CoreException {
        Document doc = this.getDocumentFromStream(inStream);
        Iterator itr = doc.getDescendants((Filter)new ElementFilter("ChangeRequest", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0));
        while (itr.hasNext()) {
            Element element = (Element)itr.next();
            String title = element.getChildText("title", IOslcCoreConstants.NAMESPACE_DC);
            String id = element.getChildText("identifier", IOslcCoreConstants.NAMESPACE_DC);
            if (title == null || id == null) continue;
            AbstractChangeRequest request = this.createChangeRequest(id, title);
            request.setType(element.getChildText("type", IOslcCoreConstants.NAMESPACE_DC));
            request.setDescription(element.getChildText("description", IOslcCoreConstants.NAMESPACE_DC));
            request.setSubject(element.getChildText("subject", IOslcCoreConstants.NAMESPACE_DC));
            request.setCreator(element.getChildText("creator", IOslcCoreConstants.NAMESPACE_DC));
            request.setModified(element.getChildText("modified", IOslcCoreConstants.NAMESPACE_DC));
            requests.add(request);
        }
    }

    protected abstract AbstractChangeRequest createChangeRequest(String var1, String var2);

    public void updateRepositoryConfiguration(IProgressMonitor monitor) throws CoreException {
        this.configuration.clear();
        this.downloadServiceDescriptor(this.configuration, monitor);
    }

    public abstract TaskData getTaskData(String var1, TaskAttributeMapper var2, IProgressMonitor var3) throws CoreException;

    public abstract RepositoryResponse putTaskData(TaskData var1, Set<TaskAttribute> var2, IProgressMonitor var3) throws CoreException;

    public RepositoryResponse postTaskData(TaskData taskData, IProgressMonitor monitor) throws CoreException {
        Element e;
        Element root = new Element("ChangeRequest", IOslcCoreConstants.NAMESPACE_OSLC_CM_1_0);
        Document doc = new Document(root);
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("title");
        if (attribute != null) {
            e = new Element(attribute.getId(), IOslcCoreConstants.NAMESPACE_DC);
            e.setText(attribute.getValue());
            root.addContent((Content)e);
        }
        if ((attribute = taskData.getRoot().getMappedAttribute("description")) != null) {
            e = new Element(attribute.getId(), IOslcCoreConstants.NAMESPACE_DC);
            e.setText(attribute.getValue());
            root.addContent((Content)e);
        }
        if ((attribute = taskData.getRoot().getMappedAttribute("type")) != null) {
            e = new Element(attribute.getId(), IOslcCoreConstants.NAMESPACE_DC);
            e.setText(attribute.getValue());
            root.addContent((Content)e);
        }
        if ((attribute = taskData.getRoot().getMappedAttribute("subject")) != null) {
            e = new Element(attribute.getId(), IOslcCoreConstants.NAMESPACE_DC);
            e.setText(attribute.getValue());
            root.addContent((Content)e);
        }
        if ((attribute = taskData.getRoot().getMappedAttribute("filedAgainst")) != null) {
            e = new Element(attribute.getId(), IOslcCoreConstants.NAMESPACE_RTC_CM_1_0);
            e.setText(attribute.getValue());
            root.addContent((Content)e);
        }
        PostMethod method = this.createPostMethod(this.getConfiguration(monitor).getDefaultFactory().getUrl());
        method.setRequestHeader("Accept", "application/x-oslc-cm-change-request+xml");
        method.setRequestHeader("Content-Type", "application/x-oslc-cm-change-request+xml");
        XMLOutputter out = new XMLOutputter(Format.getCompactFormat());
        try {
            method.setRequestEntity((RequestEntity)new StringRequestEntity(out.outputString(doc), "application/x-oslc-cm-change-request+xml", UTF_8));
        }
        catch (UnsupportedEncodingException e1) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Error creating new change request: " + e1.getMessage(), (Throwable)e1));
        }
        RequestHandler<RepositoryResponse> handler = new RequestHandler<RepositoryResponse>("Creating"){

            @Override
            public RepositoryResponse run(HttpMethodBase method, IProgressMonitor monitor) throws CoreException {
                Header header = method.getResponseHeader("Location");
                if (header != null && header.getValue() != null) {
                    String location = header.getValue();
                    return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, location);
                }
                return null;
            }
        };
        return this.executeMethod((HttpMethodBase)method, handler, monitor);
    }

    protected GetMethod createGetMethod(String requestPath) {
        GetMethod method = new GetMethod(this.getRequestPath(requestPath));
        method.setFollowRedirects(true);
        method.setDoAuthentication(true);
        method.setRequestHeader("Accept", "application/xml");
        return method;
    }

    protected PostMethod createPostMethod(String requestPath) {
        PostMethod method = new PostMethod(this.getRequestPath(requestPath));
        method.setFollowRedirects(false);
        method.setDoAuthentication(true);
        return method;
    }

    protected PutMethod createPutMethod(String requestPath) {
        PutMethod method = new PutMethod(this.getRequestPath(requestPath));
        method.setFollowRedirects(false);
        method.setDoAuthentication(true);
        return method;
    }

    protected <T> T executeMethod(HttpMethodBase method, RequestHandler<T> handler, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(handler.getRequestName(), -1);
            HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
            int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            this.handleReturnCode(code, method);
            T t = handler.run(method, monitor);
            return t;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.oslc.core", "An unexpected network error has occurred: " + e.getMessage(), (Throwable)e));
        }
        finally {
            if (method != null) {
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            }
            monitor.done();
        }
    }

    public String getRequestPath(String repositoryUrl) {
        if (repositoryUrl.startsWith("./")) {
            return String.valueOf(WebUtil.getRequestPath((String)this.location.getUrl())) + repositoryUrl.substring(1);
        }
        if (repositoryUrl.startsWith("/")) {
            return String.valueOf(WebUtil.getRequestPath((String)this.location.getUrl())) + repositoryUrl;
        }
        return WebUtil.getRequestPath((String)repositoryUrl);
    }

    protected void handleReturnCode(int code, HttpMethodBase method) throws CoreException {
        try {
            if (code == 200) {
                return;
            }
            if (code == 302 || code == 201) {
                return;
            }
            if (code == 401 || code == 403) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Unable to log into server, ensure repository credentials are correct."));
            }
            if (code == 412) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Mid-air collision occurred."));
            }
            if (code == 409) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "A conflict occurred."));
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Unknown error occurred. Http Code: " + code + " Request: " + method.getURI() + " Response: " + method.getResponseBodyAsString()));
        }
        catch (URIException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network Error: " + e.getMessage()));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Network Error: " + e.getMessage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class RequestHandler<T> {
        private final String requestName;

        public RequestHandler(String requestName) {
            this.requestName = requestName;
        }

        public abstract T run(HttpMethodBase var1, IProgressMonitor var2) throws CoreException, IOException;

        public String getRequestName() {
            return this.requestName;
        }
    }
}

