/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.internal.tasks.ui.RefactorRepositoryUrlOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;

public class EditRepositoryWizard
extends Wizard
implements INewWizard {
    private ITaskRepositoryPage settingsPage;
    private final TaskRepository repository;

    public EditRepositoryWizard(TaskRepository repository) {
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY_SETTINGS);
        this.setWindowTitle(Messages.EditRepositoryWizard_Properties_for_Task_Repository);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            boolean finishAccepted = this.settingsPage.preFinish(this.repository);
            if (finishAccepted) {
                String oldUrl = this.repository.getRepositoryUrl();
                String newUrl = this.settingsPage.getRepositoryUrl();
                if (oldUrl != null && newUrl != null && !oldUrl.equals(newUrl)) {
                    TasksUi.getTaskActivityManager().deactivateActiveTask();
                    RefactorRepositoryUrlOperation operation = new RefactorRepositoryUrlOperation(this.repository, oldUrl, newUrl);
                    try {
                        this.getContainer().run(true, false, (IRunnableWithProgress)operation);
                    }
                    catch (InvocationTargetException e) {
                        StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", Messages.EditRepositoryWizard_Failed_to_refactor_repository_urls, (Throwable)e), 3);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.repository.getConnectorKind().equals("local")) {
                    this.repository.setRepositoryUrl(newUrl);
                }
                this.settingsPage.performFinish(this.repository);
                if (oldUrl != null && newUrl != null && !oldUrl.equals(newUrl)) {
                    TasksUiPlugin.getRepositoryManager().notifyRepositoryUrlChanged(this.repository, oldUrl);
                }
                TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(this.repository, new TaskRepositoryDelta(TaskRepositoryDelta.Type.ALL));
                TasksUiPlugin.getExternalizationManager().requestSave();
            }
            return finishAccepted;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.repository.getConnectorKind());
        this.settingsPage = connectorUi.getSettingsPage(this.repository);
        if (this.settingsPage instanceof AbstractRepositorySettingsPage) {
            ((AbstractRepositorySettingsPage)this.settingsPage).setRepository(this.repository);
            ((AbstractRepositorySettingsPage)this.settingsPage).setVersion(this.repository.getVersion());
        }
        this.settingsPage.setWizard((IWizard)this);
        this.addPage(this.settingsPage);
    }

    public boolean canFinish() {
        return this.settingsPage.isPageComplete();
    }

    public ITaskRepositoryPage getSettingsPage() {
        return this.settingsPage;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }
}

