/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.DateTimeTemlate;
import org.eclipse.mylyn.wikitext.mediawiki.core.Template;
import org.eclipse.mylyn.wikitext.mediawiki.core.TemplateResolver;

public class BuiltInTemplateResolver
extends TemplateResolver {
    private static Map<String, Template> builtInTemplates = new HashMap<String, Template>();

    static {
        BuiltInTemplateResolver.registerTemplate(new Template("mdash", "&nbsp;&mdash; "));
        BuiltInTemplateResolver.registerTemplate(new Template("mdash", "&nbsp;&mdash; "));
        BuiltInTemplateResolver.registerTemplate(new Template("ndash", "&nbsp;&ndash; "));
        BuiltInTemplateResolver.registerTemplate(new Template("emdash", "&nbsp;&mdash; "));
        BuiltInTemplateResolver.registerTemplate(new Template("endash", "&nbsp;&ndash; "));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTYEAR", "yyyy"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTMONTH", "MM"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTMONTHNAME", "MMMMMMMM"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTMONTHNAMEGEN", "MMMMMMMM"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTMONTHABBREV", "MMM"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTDAY", "dd"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTDAY2", "dd"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTDOW", "F"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTDAYNAME", "EEEEEEEE"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTTIME", "HH:mm"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTHOUR", "HH"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTWEEK", "ww"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemlate("CURRENTTIMESTAMP", "yyyyMMddHHmmss"));
    }

    public Template resolveTemplate(String templateName) {
        return builtInTemplates.get(templateName);
    }

    private static void registerTemplate(Template template) {
        builtInTemplates.put(template.getName(), template);
    }
}

