/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.util.css;

import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.core.util.css.SparseCharSequence;

public class SparseCharSequenceTest
extends TestCase {
    private SparseCharSequence sequence;
    private String testData;

    protected void setUp() throws Exception {
        super.setUp();
        this.configureTest("one /* two\n\n three */ four\n/* five */");
    }

    private void configureTest(String testData) {
        this.testData = testData;
        this.sequence = new SparseCharSequence((CharSequence)testData, Pattern.compile("/\\*.*?\\*/", 40));
    }

    public void testLength() {
        SparseCharSequenceTest.assertEquals((int)10, (int)this.sequence.length());
    }

    public void testCharAt() {
        char c;
        int x = 0;
        while (x < 4) {
            c = this.sequence.charAt(x);
            SparseCharSequenceTest.assertEquals((char)this.testData.charAt(x), (char)c);
            ++x;
        }
        x = 4;
        while (x < 10) {
            c = this.sequence.charAt(x);
            SparseCharSequenceTest.assertEquals((char)this.testData.charAt(x + 17), (char)c);
            ++x;
        }
    }

    public void testOriginalOffsetOf() {
        int x = 0;
        while (x < this.sequence.length()) {
            int originalOffset = x;
            if (x >= 4) {
                originalOffset += 17;
            }
            SparseCharSequenceTest.assertEquals((int)originalOffset, (int)this.sequence.originalOffsetOf(x));
            ++x;
        }
    }

    public void testSubSequence() {
        SparseCharSequenceTest.assertEquals((String)"", (String)this.sequence.subSequence(0, 0).toString());
        SparseCharSequenceTest.assertEquals((String)"one ", (String)this.sequence.subSequence(0, 4).toString());
        SparseCharSequenceTest.assertEquals((String)"ne  ", (String)this.sequence.subSequence(1, 5).toString());
        SparseCharSequenceTest.assertEquals((String)"  fou", (String)this.sequence.subSequence(3, 8).toString());
        SparseCharSequenceTest.assertEquals((String)" four", (String)this.sequence.subSequence(4, 9).toString());
        SparseCharSequenceTest.assertEquals((String)"four\n", (String)this.sequence.subSequence(5, 10).toString());
    }

    public void testToString() {
        SparseCharSequenceTest.assertEquals((String)"one  four\n", (String)this.sequence.toString());
    }

    public void testCharAtOutOfBounds() {
        int x = -1;
        while (x < this.testData.length() + 2) {
            if (x < 0 || x >= this.sequence.length()) {
                try {
                    this.sequence.charAt(x);
                    SparseCharSequenceTest.fail((String)("expected exception on index " + x));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
            ++x;
        }
    }
}

