/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.XslfoDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class XslfoDocumentBuilderTest
extends TestCase {
    private MarkupParser parser;
    private StringWriter out;
    private XslfoDocumentBuilder builder;

    public void setUp() {
        this.parser = new MarkupParser();
        this.parser.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        this.out = new StringWriter();
        this.builder = new XslfoDocumentBuilder((Writer)this.out);
        this.parser.setBuilder((DocumentBuilder)this.builder);
    }

    public void testImageWithWidthInPx() {
        ImageAttributes attributes = new ImageAttributes();
        attributes.setWidth(10);
        this.builder.image((Attributes)attributes, "some/image.png");
        String generatedContent = this.out.toString();
        TestUtil.println("OUT: \n" + generatedContent);
        XslfoDocumentBuilderTest.assertTrue((boolean)generatedContent.contains("width=\"10px\""));
    }

    public void testImageWithWidthInPct() {
        ImageAttributes attributes = new ImageAttributes();
        attributes.setWidth(10);
        attributes.setWidthPercentage(true);
        this.builder.image((Attributes)attributes, "some/image.png");
        String generatedContent = this.out.toString();
        TestUtil.println("OUT: \n" + generatedContent);
        XslfoDocumentBuilderTest.assertTrue((boolean)generatedContent.contains("width=\"10%\""));
    }

    public void testImageWithHeightInPx() {
        ImageAttributes attributes = new ImageAttributes();
        attributes.setHeight(10);
        this.builder.image((Attributes)attributes, "some/image.png");
        String generatedContent = this.out.toString();
        TestUtil.println("OUT: \n" + generatedContent);
        XslfoDocumentBuilderTest.assertTrue((boolean)generatedContent.contains("height=\"10px\""));
    }

    public void testImageWithHeightInPct() {
        ImageAttributes attributes = new ImageAttributes();
        attributes.setHeight(10);
        attributes.setHeightPercentage(true);
        this.builder.image((Attributes)attributes, "some/image.png");
        String generatedContent = this.out.toString();
        TestUtil.println("OUT: \n" + generatedContent);
        XslfoDocumentBuilderTest.assertTrue((boolean)generatedContent.contains("height=\"10%\""));
    }
}

