/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tests;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.core.WikiTextPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTraversal {
    private static final Pattern BUNDLE_RESOURCE_35 = Pattern.compile("(\\d+)\\..*");

    public void visitClasses(Visitor visitor) {
        this.visitClasses(ClassTraversal.class, visitor);
    }

    /*
     * Unable to fully structure code
     */
    private void visitClasses(Class<ClassTraversal> classOnClasspath, Visitor visitor) {
        loader = classOnClasspath.getClassLoader();
        resourceOfClass = String.valueOf(classOnClasspath.getCanonicalName().replace('.', '/')) + ".class";
        try {
            resources = loader.getResources(resourceOfClass);
            if (true) ** GOTO lbl32
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        do {
            if ((protocol = (url = resources.nextElement()).getProtocol()).equals("file")) {
                file = url.getFile();
                try {
                    file = URLDecoder.decode(file.substring(0, file.indexOf(resourceOfClass)), "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
                this.visitClasses(loader, new File(file), new File(file), visitor);
                continue;
            }
            if (protocol.equals("bundleresource")) {
                host = url.getHost();
                bundle35Matcher = ClassTraversal.BUNDLE_RESOURCE_35.matcher(host);
                if (bundle35Matcher.matches()) {
                    host = bundle35Matcher.group(1);
                }
                bundleId = Long.parseLong(host);
                bundle = WikiTextPlugin.getDefault().getBundle().getBundleContext().getBundle(bundleId);
                if (bundle == null) {
                    throw new IllegalStateException("Cannot get bundle " + bundleId);
                }
                path = url.getFile();
                path = path.substring(0, path.indexOf(resourceOfClass));
                this.visitClasses(bundle, path, visitor);
                continue;
            }
            throw new IllegalStateException("Unimplemented protocol: " + protocol);
lbl32:
            // 3 sources

        } while (resources.hasMoreElements());
    }

    private void visitClasses(ClassLoader loader, File root, File file, Visitor visitor) {
        File[] files = file.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    File child = fileArray[n2];
                    if (child.isDirectory()) {
                        this.visitClasses(loader, root, child, visitor);
                    } else {
                        String path = child.getPath();
                        if (path.endsWith(".class")) {
                            Class<?> clazz;
                            String fqn = path.substring(root.getPath().length() + 1, path.length() - ".class".length());
                            fqn = fqn.replace('/', '.').replace('\\', '.');
                            try {
                                clazz = Class.forName(fqn, true, loader);
                            }
                            catch (LinkageError linkageError) {
                                break block8;
                            }
                            catch (Exception exception) {
                                break block8;
                            }
                            visitor.visit(clazz);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void visitClasses(Bundle bundle, String path, Visitor visitor) {
        Enumeration entries = bundle.findEntries(path, "*.class", true);
        while (entries.hasMoreElements()) {
            Class clazz;
            URL element = (URL)entries.nextElement();
            String filePath = element.getFile();
            if (filePath.indexOf("org/eclipse/mylyn") == -1) continue;
            filePath = filePath.substring(filePath.indexOf("org/eclipse/mylyn"));
            String fqn = filePath.substring(0, filePath.length() - ".class".length()).replace('/', '.');
            try {
                clazz = bundle.loadClass(fqn);
            }
            catch (Exception exception) {
                continue;
            }
            visitor.visit(clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor {
        public void visit(Class<?> var1);
    }
}

