/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.help;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.mylyn.internal.wikitext.ui.editor.help.Messages;
import org.eclipse.mylyn.wikitext.core.WikiText;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class HelpContent {
    private final Bundle provider;
    private final String resourcePath;
    private final String resourceContentLanguage;
    private final String markupLanguageName;

    public HelpContent(Bundle provider, String resourcePath, String resourceContentLanguage, String markupLanguage) {
        if (provider == null || resourcePath == null || markupLanguage == null) {
            throw new IllegalArgumentException();
        }
        this.provider = provider;
        this.resourcePath = resourcePath;
        this.resourceContentLanguage = resourceContentLanguage;
        this.markupLanguageName = markupLanguage;
    }

    public String getMarkupLanguageName() {
        return this.markupLanguageName;
    }

    public Bundle getProvider() {
        return this.provider;
    }

    public String getContent() throws IOException {
        try {
            String content = null;
            URL resource = this.getResource();
            InputStreamReader reader = new InputStreamReader(new BufferedInputStream(resource.openStream()));
            try {
                int i;
                StringBuilder buf = new StringBuilder();
                while ((i = ((Reader)reader).read()) != -1) {
                    buf.append((char)i);
                }
                content = buf.toString();
            }
            finally {
                ((Reader)reader).close();
            }
            if (this.resourceContentLanguage == null || "html".equalsIgnoreCase(this.resourceContentLanguage)) {
                return content;
            }
            MarkupLanguage markupLanguage = WikiText.getMarkupLanguage((String)this.resourceContentLanguage);
            if (markupLanguage == null) {
                throw new IOException(NLS.bind((String)Messages.HelpContent_noSuchMarkupLanguage, (Object[])new Object[]{this.resourceContentLanguage}));
            }
            MarkupParser markupParser = new MarkupParser(markupLanguage);
            return markupParser.parseToHtml(content);
        }
        catch (Exception e) {
            throw new IOException(NLS.bind((String)Messages.HelpContent_cannotAccessContent, (Object[])new Object[]{this.provider.getSymbolicName(), this.resourcePath, e.getMessage()})){

                public Throwable getCause() {
                    return e;
                }
            };
        }
    }

    private URL getResource() throws Exception {
        int idx = this.resourcePath.lastIndexOf(46);
        ArrayList<String> paths = new ArrayList<String>();
        if (idx != -1) {
            String basePath = this.resourcePath.substring(0, idx);
            String extension = this.resourcePath.substring(idx + 1);
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (variant.length() > 0) {
                paths.add(String.valueOf(basePath) + "_" + language + "_" + country + "_" + variant + "." + extension);
            }
            if (country.length() > 0) {
                paths.add(String.valueOf(basePath) + "_" + language + "_" + country + "." + extension);
            }
            if (language.length() > 0) {
                paths.add(String.valueOf(basePath) + "_" + language + "." + extension);
            }
        }
        paths.add(this.resourcePath);
        for (String path : paths) {
            URL resource = this.provider.getResource(path);
            if (resource == null) continue;
            return resource;
        }
        throw new Exception(NLS.bind((String)Messages.HelpContent_cannotFindResource, (Object[])new Object[]{this.resourcePath, this.provider.getSymbolicName()}));
    }
}

