/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.spi.db;

import java.io.PrintStream;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.internal.db.ddl.DBSchemaElement;
import org.eclipse.net4j.internal.db.ddl.DBTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSchema
extends DBSchemaElement
implements IDBSchema {
    private String name;
    private Map<String, DBTable> tables = new HashMap<String, DBTable>();
    private boolean locked;

    public DBSchema(String name) {
        this.name = name;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public IDBSchema getSchema() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IDBTable addTable(String name) throws DBException {
        this.assertUnlocked();
        if (this.tables.containsKey(name)) {
            throw new DBException("DBTable exists: " + name);
        }
        DBTable table = new DBTable(this, name);
        this.tables.put(name, table);
        return table;
    }

    @Override
    public IDBTable removeTable(String name) {
        this.assertUnlocked();
        return this.tables.remove(name);
    }

    @Override
    public IDBTable getTable(String name) {
        return this.tables.get(name);
    }

    @Override
    public IDBTable[] getTables() {
        return this.tables.values().toArray(new DBTable[this.tables.size()]);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean lock() {
        this.locked = true;
        return true;
    }

    @Override
    public Set<IDBTable> create(IDBAdapter dbAdapter, Connection connection) throws DBException {
        return dbAdapter.createTables(this.tables.values(), connection);
    }

    @Override
    public Set<IDBTable> create(IDBAdapter dbAdapter, DataSource dataSource) throws DBException {
        return this.create(dbAdapter, DBUtil.createConnectionProvider(dataSource));
    }

    @Override
    public Set<IDBTable> create(IDBAdapter dbAdapter, IDBConnectionProvider connectionProvider) throws DBException {
        Connection connection = null;
        try {
            connection = connectionProvider.getConnection();
            if (connection == null) {
                throw new DBException("No connection available from " + connectionProvider);
            }
            Set<IDBTable> set = this.create(dbAdapter, connection);
            return set;
        }
        finally {
            DBUtil.close(connection);
        }
    }

    @Override
    public void drop(IDBAdapter dbAdapter, Connection connection) throws DBException {
        dbAdapter.dropTables(this.tables.values(), connection);
    }

    @Override
    public void drop(IDBAdapter dbAdapter, DataSource dataSource) throws DBException {
        this.drop(dbAdapter, DBUtil.createConnectionProvider(dataSource));
    }

    @Override
    public void drop(IDBAdapter dbAdapter, IDBConnectionProvider connectionProvider) throws DBException {
        Connection connection = null;
        try {
            connection = connectionProvider.getConnection();
            this.drop(dbAdapter, connection);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    @Override
    public void export(Connection connection, PrintStream out) throws DBException {
        IDBTable[] iDBTableArray = this.getTables();
        int n = iDBTableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBTable table = iDBTableArray[n2];
            this.export(table, connection, out);
            ++n2;
        }
    }

    private void export(final IDBTable table, Connection connection, final PrintStream out) {
        if (DBUtil.select(connection, new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                if (row == 0) {
                    String tableName = table.getName();
                    out.println(tableName);
                    int i = 0;
                    while (i < tableName.length()) {
                        out.print("=");
                        ++i;
                    }
                    out.println();
                }
                out.println(Arrays.asList(values));
                return true;
            }
        }, table.getFields()) > 0) {
            out.println();
        }
    }

    @Override
    public void export(DataSource dataSource, PrintStream out) throws DBException {
        this.export(DBUtil.createConnectionProvider(dataSource), out);
    }

    @Override
    public void export(IDBConnectionProvider connectionProvider, PrintStream out) throws DBException {
        Connection connection = null;
        try {
            connection = connectionProvider.getConnection();
            this.export(connection, out);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    public void assertUnlocked() throws DBException {
        if (this.locked) {
            throw new DBException("DBSchema locked: " + this.name);
        }
    }
}

