/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConcurrentArray<E> {
    protected E[] elements;
    private final E[] EMPTY = this.newArray(0);

    public boolean isEmpty() {
        return this.elements == null;
    }

    public E[] get() {
        return this.elements == null ? this.EMPTY : this.elements;
    }

    public synchronized void add(E element) {
        if (!this.validate(element)) {
            return;
        }
        if (this.elements == null) {
            E[] array = this.newArray(1);
            array[0] = element;
            this.elements = array;
            this.firstElementAdded();
        } else {
            int length = this.elements.length;
            E[] array = this.newArray(length + 1);
            System.arraycopy(this.elements, 0, array, 0, length);
            array[length] = element;
            this.elements = array;
        }
    }

    public synchronized boolean remove(E element) {
        if (this.elements != null) {
            int length = this.elements.length;
            if (length == 1) {
                if (this.elements[0] == element) {
                    this.elements = null;
                    this.lastElementRemoved();
                    return true;
                }
            } else {
                int i = 0;
                while (i < length) {
                    E e = this.elements[i];
                    if (e == element) {
                        E[] array = this.newArray(length - 1);
                        if (i > 0) {
                            System.arraycopy(this.elements, 0, array, 0, i);
                        }
                        if (i + 1 <= length - 1) {
                            System.arraycopy(this.elements, i + 1, array, i, length - 1 - i);
                        }
                        this.elements = array;
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected boolean validate(E element) {
        return true;
    }

    protected void firstElementAdded() {
    }

    protected void lastElementRemoved() {
    }

    protected abstract E[] newArray(int var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DuplicateCounter<E>
    extends ConcurrentArray<E> {
        private int maxDuplicates;

        public final int getMaxDuplicates() {
            return this.maxDuplicates;
        }

        @Override
        protected boolean validate(E element) {
            if (this.elements != null) {
                int duplicates = 0;
                int i = 0;
                while (i < this.elements.length) {
                    if (this.equals(element, this.elements[i])) {
                        ++duplicates;
                    }
                    ++i;
                }
                if (duplicates > this.maxDuplicates) {
                    this.maxDuplicates = duplicates;
                }
            }
            return true;
        }

        protected boolean equals(E e1, E e2) {
            return e1 == e2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Unique<E>
    extends ConcurrentArray<E> {
        @Override
        protected boolean validate(E element) {
            if (this.elements != null) {
                int i = 0;
                while (i < this.elements.length) {
                    if (this.equals(element, this.elements[i])) {
                        this.violatingUniqueness(element);
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        protected boolean equals(E e1, E e2) {
            return e1 == e2;
        }

        protected void violatingUniqueness(E element) {
        }
    }
}

