/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.channel.ChannelOutputStream;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.MonitorCanceledIndication;
import org.eclipse.net4j.signal.MonitorProgressIndication;
import org.eclipse.net4j.signal.RemoteExceptionIndication;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.RequestWithMonitoring;
import org.eclipse.net4j.signal.SetTimeoutIndication;
import org.eclipse.net4j.signal.SetTimeoutRequest;
import org.eclipse.net4j.signal.Signal;
import org.eclipse.net4j.signal.SignalActor;
import org.eclipse.net4j.signal.SignalFinishedEvent;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.signal.SignalScheduledEvent;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IStreamWrapper;
import org.eclipse.net4j.util.io.StreamWrapperChain;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalProtocol<INFRA_STRUCTURE>
extends Protocol<INFRA_STRUCTURE>
implements ISignalProtocol<INFRA_STRUCTURE> {
    public static final short SIGNAL_REMOTE_EXCEPTION = -1;
    public static final short SIGNAL_MONITOR_CANCELED = -2;
    public static final short SIGNAL_MONITOR_PROGRESS = -3;
    public static final short SIGNAL_SET_TIMEOUT = -4;
    private static final int MIN_CORRELATION_ID = 1;
    private static final int MAX_CORRELATION_ID = Integer.MAX_VALUE;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, SignalProtocol.class);
    private static final ContextTracer STREAM_TRACER = new ContextTracer(OM.DEBUG_BUFFER_STREAM, SignalProtocol.class);
    private long timeout = 10000L;
    private IStreamWrapper streamWrapper;
    private Map<Integer, Signal> signals = new HashMap<Integer, Signal>();
    private int nextCorrelationID = 1;
    private boolean failingOver;

    public SignalProtocol(String type) {
        super(type);
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        long oldTimeout = this.timeout;
        this.handleSetTimeOut(timeout);
        if (oldTimeout != this.timeout && this.isActive()) {
            this.sendSetTimeout();
        }
    }

    @Override
    public IStreamWrapper getStreamWrapper() {
        return this.streamWrapper;
    }

    @Override
    public void setStreamWrapper(IStreamWrapper streamWrapper) {
        this.streamWrapper = streamWrapper;
    }

    @Override
    public void addStreamWrapper(IStreamWrapper streamWrapper) {
        this.streamWrapper = this.streamWrapper == null ? streamWrapper : new StreamWrapperChain(streamWrapper, this.streamWrapper);
    }

    @Override
    public IChannel open(IConnector connector) {
        return connector.openChannel(this);
    }

    @Override
    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForSignals(long timeout) {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            while (!this.signals.isEmpty()) {
                try {
                    this.signals.wait(timeout);
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBuffer(IBuffer buffer) {
        Signal signal;
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int correlationID = byteBuffer.getInt();
        if (TRACER.isEnabled()) {
            TRACER.trace("Received buffer for correlation " + correlationID);
        }
        boolean newSignalScheduled = false;
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            if (correlationID > 0) {
                signal = this.signals.get(-correlationID);
                if (signal == null) {
                    short signalID = byteBuffer.getShort();
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Got signalID: " + signalID);
                    }
                    signal = this.provideSignalReactor(signalID);
                    signal.setCorrelationID(-correlationID);
                    signal.setBufferInputStream(new SignalInputStream(this.getTimeout()));
                    if (signal instanceof IndicationWithResponse) {
                        signal.setBufferOutputStream(new SignalOutputStream(-correlationID, signalID, false));
                    }
                    this.signals.put(-correlationID, signal);
                    this.getExecutorService().execute(signal);
                    newSignalScheduled = true;
                }
            } else {
                signal = this.signals.get(-correlationID);
            }
        }
        if (signal != null) {
            IListener[] listeners;
            if (newSignalScheduled && (listeners = this.getListeners()) != null) {
                this.fireEvent((IEvent)new SignalScheduledEvent(this, signal), listeners);
            }
            BufferInputStream inputStream = signal.getBufferInputStream();
            inputStream.handleBuffer(buffer);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.trace("Discarding buffer");
            }
            buffer.release();
        }
    }

    public String toString() {
        return MessageFormat.format("SignalProtocol[{0}]", this.getType());
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        if (this.timeout != 10000L) {
            this.sendSetTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBeforeDeactivate() throws Exception {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            int waitMillis = 10000;
            long stop = System.currentTimeMillis() + (long)waitMillis;
            while (!this.signals.isEmpty() && System.currentTimeMillis() < stop) {
                this.signals.wait(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDeactivate() throws Exception {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            this.signals.clear();
        }
        IChannel channel = this.getChannel();
        if (channel != null) {
            channel.close();
            this.setChannel(null);
        }
        super.doDeactivate();
    }

    @Override
    protected void handleChannelDeactivation() {
        if (!this.failingOver) {
            super.handleChannelDeactivation();
        }
    }

    protected final SignalReactor provideSignalReactor(short signalID) {
        this.checkActive();
        switch (signalID) {
            case -1: {
                return new RemoteExceptionIndication(this);
            }
            case -2: {
                return new MonitorCanceledIndication(this);
            }
            case -3: {
                return new MonitorProgressIndication(this);
            }
            case -4: {
                return new SetTimeoutIndication(this);
            }
        }
        SignalReactor signal = this.createSignalReactor(signalID);
        if (signal == null) {
            throw new IllegalArgumentException("Invalid signalID " + signalID);
        }
        return signal;
    }

    protected SignalReactor createSignalReactor(short signalID) {
        return null;
    }

    protected boolean isSendingTimeoutChanges() {
        return true;
    }

    synchronized int getNextCorrelationID() {
        int correlationID = this.nextCorrelationID;
        if (this.nextCorrelationID == Integer.MAX_VALUE) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Correlation ID wrap-around");
            }
            this.nextCorrelationID = 1;
        } else {
            ++this.nextCorrelationID;
        }
        return correlationID;
    }

    InputStream wrapInputStream(InputStream in) throws IOException {
        if (this.streamWrapper != null) {
            in = this.streamWrapper.wrapInputStream(in);
        }
        return in;
    }

    OutputStream wrapOutputStream(OutputStream out) throws IOException {
        if (this.streamWrapper != null) {
            out = this.streamWrapper.wrapOutputStream(out);
        }
        return out;
    }

    void finishInputStream(InputStream in) throws IOException {
        if (this.streamWrapper != null) {
            this.streamWrapper.finishInputStream(in);
        }
    }

    void finishOutputStream(OutputStream out) throws IOException {
        if (this.streamWrapper != null) {
            this.streamWrapper.finishOutputStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startSignal(SignalActor signalActor, long timeout) throws Exception {
        this.checkArg(signalActor.getProtocol() == this, "Wrong protocol");
        short signalID = signalActor.getID();
        int correlationID = signalActor.getCorrelationID();
        signalActor.setBufferOutputStream(new SignalOutputStream(correlationID, signalID, true));
        if (signalActor instanceof RequestWithConfirmation) {
            signalActor.setBufferInputStream(new SignalInputStream(timeout));
        }
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            this.signals.put(correlationID, signalActor);
        }
        IListener[] listeners = this.getListeners();
        if (listeners != null) {
            this.fireEvent((IEvent)new SignalScheduledEvent(this, signalActor), listeners);
        }
        signalActor.runSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSignal(Signal signal, Exception exception) {
        int correlationID = signal.getCorrelationID();
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            this.signals.remove(correlationID);
            this.signals.notifyAll();
        }
        IListener[] listeners = this.getListeners();
        if (listeners != null) {
            this.fireEvent((IEvent)new SignalFinishedEvent(this, signal, exception), listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRemoteException(int correlationID, Throwable t, boolean responding) {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            Signal signal = this.signals.remove(correlationID);
            if (signal instanceof RequestWithConfirmation) {
                RequestWithConfirmation request = (RequestWithConfirmation)signal;
                request.setRemoteException(t, responding);
            }
            this.signals.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMonitorProgress(int correlationID, double totalWork, double work) {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            Signal signal = this.signals.get(correlationID);
            if (signal instanceof RequestWithMonitoring) {
                RequestWithMonitoring request = (RequestWithMonitoring)signal;
                request.setMonitorProgress(totalWork, work);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMonitorCanceled(int correlationID) {
        Map<Integer, Signal> map = this.signals;
        synchronized (map) {
            Signal signal = this.signals.get(correlationID);
            if (signal instanceof IndicationWithMonitoring) {
                IndicationWithMonitoring indication = (IndicationWithMonitoring)signal;
                indication.setMonitorCanceled();
            }
        }
    }

    void handleSetTimeOut(long timeout) {
        long oldTimeout = this.timeout;
        if (oldTimeout != timeout) {
            this.timeout = timeout;
            this.fireEvent((IEvent)new TimeoutChangedEvent(this, oldTimeout, timeout));
        }
    }

    void sendSetTimeout() {
        if (this.isSendingTimeoutChanges()) {
            try {
                new SetTimeoutRequest(this, this.timeout).send();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
    }

    class SignalInputStream
    extends BufferInputStream {
        private long timeout;

        public SignalInputStream(long timeout) {
            this.timeout = timeout;
        }

        public long getMillisBeforeTimeout() {
            return this.timeout;
        }
    }

    class SignalOutputStream
    extends ChannelOutputStream {
        public SignalOutputStream(final int correlationID, final short signalID, boolean addSignalID) {
            super(SignalProtocol.this.getChannel(), new IBufferProvider(addSignalID){
                private IBufferProvider delegate;
                private boolean firstBuffer;
                {
                    this.delegate = SignalProtocol.this.getBufferProvider();
                    this.firstBuffer = bl;
                }

                public short getBufferCapacity() {
                    return this.delegate.getBufferCapacity();
                }

                public IBuffer provideBuffer() {
                    IChannel channel = SignalProtocol.this.getChannel();
                    if (channel == null) {
                        throw new IORuntimeException("No channel for protocol " + SignalProtocol.this);
                    }
                    IBuffer buffer = this.delegate.provideBuffer();
                    ByteBuffer byteBuffer = buffer.startPutting(channel.getID());
                    if (STREAM_TRACER.isEnabled()) {
                        STREAM_TRACER.trace("Providing buffer for correlation " + correlationID);
                    }
                    byteBuffer.putInt(correlationID);
                    if (this.firstBuffer) {
                        if (TRACER.isEnabled()) {
                            STREAM_TRACER.trace("Put signal id " + signalID);
                        }
                        byteBuffer.putShort(signalID);
                    }
                    this.firstBuffer = false;
                    return buffer;
                }

                public void retainBuffer(IBuffer buffer) {
                    this.delegate.retainBuffer(buffer);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TimeoutChangedEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private long oldTimeout;
        private long newTimeout;

        private TimeoutChangedEvent(ISignalProtocol<?> source, long oldTimeout, long newTimeout) {
            super(source);
            this.oldTimeout = oldTimeout;
            this.newTimeout = newTimeout;
        }

        public SignalProtocol<?> getSource() {
            return (SignalProtocol)super.getSource();
        }

        public long getOldTimeout() {
            return this.oldTimeout;
        }

        public long getNewTimeout() {
            return this.newTimeout;
        }

        public String toString() {
            return "TimeoutChangedEvent [oldTimeout=" + this.oldTimeout + ", newTimeout=" + this.newTimeout + ", source=" + this.source + "]";
        }
    }
}

