/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeAnchor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddImportCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.jface.text.IDocument;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeProposalSubProcessor {
    private static final String ANCHOR_GROUP_ID = "AnchorNameID";
    private static final String ADD_IMPORT_ID = "org.eclipse.jdt.ui.correction.addImport";

    public static LinkedCorrectionProposal changeTypeToAnchored(ICompilationUnit cu, String fullName, Name type, String enclosingTeamName) {
        AST ast = type.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String[] variables = TypeProposalSubProcessor.matchingVariables((ASTNode)type, enclosingTeamName);
        String firstAnchor = variables.length > 0 ? variables[0] : "aTeam";
        SimpleName anchorName = (SimpleName)rewrite.createStringPlaceholder(firstAnchor, 42);
        TypeAnchor anchor = ast.newTypeAnchor((Name)anchorName);
        Name newTypeName = type;
        if (type.isQualifiedName()) {
            newTypeName = ((QualifiedName)type).getName();
        }
        newTypeName = (Name)ASTNode.copySubtree((AST)ast, (ASTNode)newTypeName);
        ParameterizedType newType = ast.newParameterizedType((Type)ast.newSimpleType(newTypeName));
        newType.typeArguments().add(anchor);
        rewrite.replace((ASTNode)type, (ASTNode)newType, null);
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
        int relevance = 13;
        String label = CorrectionMessages.OTQuickFix_Type_change_type_to_anchored;
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, relevance, image);
        proposal.addLinkedPosition(rewrite.track((ASTNode)anchorName), true, ANCHOR_GROUP_ID);
        if (variables.length > 1) {
            int i = 0;
            while (i < variables.length) {
                proposal.addLinkedPositionProposal(ANCHOR_GROUP_ID, variables[i], null);
                ++i;
            }
        }
        return proposal;
    }

    private static String[] matchingVariables(ASTNode node, String enclosingTeamName) {
        ArrayList<String> list = new ArrayList<String>();
        ASTNode previous = null;
        while (node != null && node.getNodeType() != 15) {
            switch (node.getNodeType()) {
                case 8: {
                    list.addAll(TypeProposalSubProcessor.getMatchingLocalsPriorTo((Block)node, enclosingTeamName, previous));
                    break;
                }
                case 31: {
                    for (Object fieldObj : ((MethodDeclaration)node).parameters()) {
                        SingleVariableDeclaration param = (SingleVariableDeclaration)fieldObj;
                        TypeProposalSubProcessor.addSingleVarIfMatch(param.getType(), enclosingTeamName, param, list);
                    }
                    break;
                }
                case 55: 
                case 94: {
                    FieldDeclaration[] fieldDeclarationArray = ((TypeDeclaration)node).getFields();
                    int n = fieldDeclarationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FieldDeclaration field = fieldDeclarationArray[n2];
                        TypeProposalSubProcessor.addFragmentsIfMatch(field.getType(), enclosingTeamName, field.fragments(), list);
                        ++n2;
                    }
                    break;
                }
            }
            previous = node;
            node = node.getParent();
        }
        return list.toArray(new String[list.size()]);
    }

    private static ArrayList<String> getMatchingLocalsPriorTo(Block block, String enclosingTeamName, ASTNode current) {
        ArrayList<String> result = new ArrayList<String>();
        if (current != null) {
            List statements = block.statements();
            int i = 0;
            while (i < statements.size()) {
                Object statement = statements.get(i);
                if (statement instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement var = (VariableDeclarationStatement)statement;
                    TypeProposalSubProcessor.addFragmentsIfMatch(var.getType(), enclosingTeamName, var.fragments(), result);
                }
                if (statement == current) break;
                ++i;
            }
        }
        return result;
    }

    private static void addFragmentsIfMatch(Type typeNode, String enclosingTeamName, List fragments, List<String> result) {
        if (typeNode.isSimpleType() && TypeProposalSubProcessor.nameEquals(((SimpleType)typeNode).getName(), enclosingTeamName)) {
            int i = 0;
            while (i < fragments.size()) {
                result.add(((VariableDeclarationFragment)fragments.get(i)).getName().getIdentifier());
                ++i;
            }
        }
    }

    private static void addSingleVarIfMatch(Type typeNode, String enclosingTeamName, SingleVariableDeclaration var, List<String> result) {
        if (typeNode.isSimpleType() && TypeProposalSubProcessor.nameEquals(((SimpleType)typeNode).getName(), enclosingTeamName)) {
            result.add(var.getName().getIdentifier());
        }
    }

    private static boolean nameEquals(Name name, String enclosingTeamName) {
        String nameString = name.getFullyQualifiedName();
        return enclosingTeamName.equals(nameString) || enclosingTeamName.endsWith("." + nameString);
    }

    public static CUCorrectionProposal createImportInRoFisTeamProposal(ICompilationUnit cu, String fullName, Name node, int relevance, int maxProposals) {
        SimpleName simpleNameNode;
        IOTType otType;
        block8: {
            try {
                IType[] types = cu.getTypes();
                otType = OTModelManager.getOTElement((IType)types[0]);
                if (otType != null && otType.isRole()) break block8;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        IType teamType = ((IRoleType)otType).getTeamJavaType();
        cu = teamType.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        ASTParser p = ASTParser.newParser((int)4);
        p.setSource(cu);
        p.setResolveBindings(false);
        CompilationUnit astCU = (CompilationUnit)p.createAST(null);
        for (Object anImport : astCU.imports()) {
            if (!((ImportDeclaration)anImport).getName().getFullyQualifiedName().equals(fullName)) continue;
            return null;
        }
        ImportRewrite importRewrite = null;
        String simpleName = fullName;
        String packName = Signature.getQualifier((String)fullName);
        if (packName.length() > 0) {
            importRewrite = StubUtility.createImportRewrite((CompilationUnit)astCU, (boolean)true);
            simpleName = importRewrite.addImport(fullName);
        }
        if (!TypeProposalSubProcessor.isLikelyTypeName(simpleName)) {
            relevance -= 2;
        }
        AddImportCorrectionProposal proposal = null;
        SimpleName simpleName2 = simpleNameNode = node.isQualifiedName() ? ((QualifiedName)node).getName() : (SimpleName)node;
        if (importRewrite != null && simpleName.equals(simpleNameNode.getIdentifier())) {
            Object[] arg = new String[]{BasicElementLabels.getJavaElementName((String)simpleName), BasicElementLabels.getJavaElementName((String)packName)};
            String label = Messages.format((String)CorrectionMessages.OTQuickFix_Type_add_base_import_to_enclosing_team, (Object[])arg);
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.imp_obj.gif");
            int boost = QualifiedTypeNameHistory.getBoost((String)fullName, (int)0, (int)maxProposals);
            proposal = new AddImportCorrectionProposal(label, cu, relevance + 100 + boost, image, packName, simpleName, simpleNameNode);
            proposal.setCommandId(ADD_IMPORT_ID);
            proposal.setImportRewrite(importRewrite);
        }
        return proposal;
    }

    private static boolean isLikelyTypeName(String name) {
        return name.length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    public static ICommandAccess getMakeImportBase(ASTNode selectedNode, ICompilationUnit cu) throws JavaModelException {
        IType[] types;
        if (selectedNode.getNodeType() != 42) {
            return null;
        }
        SimpleName name = (SimpleName)selectedNode;
        ITypeBinding type = name.resolveTypeBinding();
        if (type == null) {
            return null;
        }
        int relevance = 1000;
        IType[] iTypeArray = types = cu.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType toplevelType = iTypeArray[n2];
            IOTType ottype = OTModelManager.getOTElement((IType)toplevelType);
            if (ottype != null && ottype.isRole()) {
                return TypeProposalSubProcessor.createImportInRoFisTeamProposal(cu, type.getQualifiedName(), (Name)name, relevance, 1);
            }
            ++n2;
        }
        ImportRewrite importRewrite = StubUtility.createImportRewrite((ICompilationUnit)cu, (boolean)true);
        if (!importRewrite.setImportBase((IBinding)type)) {
            return null;
        }
        String simpleName = type.getName();
        String pack1 = type.getPackage().getNameComponents()[0];
        String displayName = String.valueOf(pack1) + "..." + simpleName;
        ASTRewriteCorrectionProposal rewriteProposal = new ASTRewriteCorrectionProposal(Messages.format((String)CorrectionMessages.OTQuickFix_Type_convertimporttobase_description, (Object[])new String[]{displayName}), cu, ASTRewrite.create((AST)selectedNode.getAST()), relevance, JavaPluginImages.get((String)"org.eclipse.jdt.ui.imp_obj.gif"));
        rewriteProposal.setImportRewrite(importRewrite);
        return rewriteProposal;
    }

    public static ICommandAccess getImportBaseclass(ASTNode selectedNode, ICompilationUnit cu) throws JavaModelException {
        if (selectedNode.getNodeType() != 40) {
            return null;
        }
        QualifiedName typeRef = (QualifiedName)selectedNode;
        ITypeBinding type = typeRef.resolveTypeBinding();
        if (type == null) {
            return null;
        }
        int relevance = 1000;
        IType[] types = cu.getTypes();
        boolean isRoleFile = false;
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType toplevelType = iTypeArray[n2];
            IOTType ottype = OTModelManager.getOTElement((IType)toplevelType);
            if (ottype != null && ottype.isRole()) {
                isRoleFile = true;
                break;
            }
            ++n2;
        }
        CUCorrectionProposal importProposal = isRoleFile ? TypeProposalSubProcessor.createImportInRoFisTeamProposal(cu, type.getQualifiedName(), (Name)typeRef, relevance, 1) : null;
        ImportRewrite importRewrite = StubUtility.createImportRewrite((ICompilationUnit)cu, (boolean)true);
        if (!isRoleFile) {
            importRewrite.addImport(type);
            if (!importRewrite.setImportBase((IBinding)type)) {
                return null;
            }
        }
        AST ast = selectedNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Name simpleTypeRef = ast.newName(typeRef.getName().getIdentifier());
        rewrite.replace(selectedNode, (ASTNode)simpleTypeRef, null);
        String simpleName = type.getName();
        String pack1 = type.getPackage().getNameComponents()[0];
        String displayName = String.valueOf(pack1) + "..." + simpleName;
        ASTRewriteCorrectionProposal rewriteProposal = new ASTRewriteCorrectionProposal(Messages.format((String)CorrectionMessages.OTQuickFix_Type_convert_fqn_to_importtobase_description, (Object[])new String[]{displayName}), cu, rewrite, relevance, JavaPluginImages.get((String)"org.eclipse.jdt.ui.imp_obj.gif"), (IJavaCompletionProposal)importProposal){
            private final /* synthetic */ IJavaCompletionProposal val$importProposal;
            {
                this.val$importProposal = iJavaCompletionProposal;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
            }

            public void apply(IDocument document) {
                super.apply(document);
                if (this.val$importProposal != null) {
                    this.val$importProposal.apply(document);
                }
            }
        };
        rewriteProposal.setImportRewrite(importRewrite);
        return rewriteProposal;
    }
}

