/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.utilities;

import org.eclipse.ocl.examples.domain.utilities.IndexableIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterable<T>
implements IndexableIterable<T> {
    private final T[] array;
    private final int firstIndex;
    private final int lastIndex;

    public ArrayIterable(T[] array) {
        this.array = array;
        this.firstIndex = 0;
        this.lastIndex = array.length;
    }

    public ArrayIterable(T[] array, int firstIndex, int lastIndex) {
        this.array = array;
        this.firstIndex = firstIndex;
        this.lastIndex = lastIndex;
    }

    @Override
    public T get(int index) {
        return this.array[this.firstIndex + index];
    }

    @Override
    public java.util.Iterator<T> iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.lastIndex - this.firstIndex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Iterator
    implements java.util.Iterator<T> {
        private int index;

        protected Iterator() {
            this.index = ArrayIterable.this.firstIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < ArrayIterable.this.lastIndex;
        }

        @Override
        public T next() {
            return ArrayIterable.this.array[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

