/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractedCollectionValue
extends AbstractValue
implements CollectionValue {
    protected final DomainCollectionType type;
    private DomainType actualType = null;

    protected AbstractedCollectionValue(ValueFactory valueFactory, DomainCollectionType type) {
        super(valueFactory);
        this.type = type;
    }

    @Override
    public Collection<Value> asCollection() {
        return this.getElements();
    }

    @Override
    public CollectionValue asCollectionValue() {
        return this;
    }

    @Override
    public List<Value> asList() {
        return new ArrayList<Value>(this.getElements());
    }

    @Override
    public Object asObject() {
        return this.getElements();
    }

    @Override
    public Value asValidValue() {
        return this;
    }

    @Override
    public DomainType getActualType() {
        if (this.actualType == null) {
            DomainStandardLibrary standardLibrary = this.valueFactory.getStandardLibrary();
            DomainType elementType = null;
            for (Value value : this.getElements()) {
                DomainType valueType = value.getActualType();
                if (valueType == null) continue;
                elementType = elementType == null ? valueType : elementType.getCommonType(standardLibrary, valueType);
            }
            this.actualType = elementType == null ? this.type : standardLibrary.getCollectionType(this.type, elementType);
        }
        return this.actualType;
    }

    protected abstract Collection<Value> getElements();

    @Override
    public DomainCollectionType getType() {
        return this.type;
    }

    @Override
    public CollectionValue isCollectionValue() {
        return this;
    }

    @Override
    public BooleanValue isEmpty() {
        return this.valueFactory.booleanValueOf(this.intSize() == 0);
    }

    @Override
    public BooleanValue notEmpty() {
        return this.valueFactory.booleanValueOf(this.intSize() != 0);
    }

    @Override
    public IntegerValue size() {
        return this.valueFactory.integerValueOf(this.intSize());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        this.toString(s, 100);
        return s.toString();
    }

    @Override
    public void toString(StringBuilder s, int lengthLimit) {
        s.append("{");
        boolean isFirst = true;
        for (Value element : this) {
            if (!isFirst) {
                s.append(",");
            }
            if (s.length() >= lengthLimit) {
                s.append("...");
                break;
            }
            element.toString(s, lengthLimit - 1);
            isFirst = false;
        }
        s.append("}");
    }
}

