/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OrderedSet;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractCollectionValue;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedSetValueImpl
extends AbstractCollectionValue<OrderedSet<Value>>
implements OrderedSetValue {
    public static OrderedSetValue intersection(ValueFactory valueFactory, DomainCollectionType type, CollectionValue left, CollectionValue right) throws InvalidValueException {
        assert (!left.isUndefined() && !right.isUndefined());
        Collection<Value> leftElements = left.asCollection();
        Collection<Value> rightElements = right.asCollection();
        int leftSize = leftElements.size();
        int rightSize = rightElements.size();
        if (leftSize == 0 || rightSize == 0) {
            return valueFactory.createOrderedSetValue(type, new Value[0]);
        }
        OrderedSetImpl<Value> results = new OrderedSetImpl<Value>(leftElements);
        results.retainAll(rightElements);
        return results.size() > 0 ? valueFactory.createOrderedSetValue(type, (OrderedSet<? extends Value>)results) : valueFactory.createOrderedSetValue(type, new Value[0]);
    }

    public static OrderedSetValue union(ValueFactory valueFactory, DomainCollectionType type, CollectionValue left, CollectionValue right) throws InvalidValueException {
        assert (!left.isUndefined() && !right.isUndefined());
        Collection<Value> leftElements = left.asCollection();
        Collection<Value> rightElements = right.asCollection();
        if (leftElements.isEmpty()) {
            return right.asOrderedSetValue();
        }
        if (rightElements.isEmpty()) {
            return left.asOrderedSetValue();
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(leftElements);
        result.addAll(rightElements);
        return new OrderedSetValueImpl(valueFactory, type, (OrderedSet<Value>)result);
    }

    public OrderedSetValueImpl(ValueFactory valueFactory, DomainCollectionType type, Value ... elements) {
        super(valueFactory, type, new OrderedSetImpl());
        if (elements != null) {
            Value[] valueArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Value element = valueArray[n2];
                ((OrderedSet)this.elements).add(element);
                ++n2;
            }
        }
    }

    public OrderedSetValueImpl(ValueFactory valueFactory, DomainCollectionType type, Collection<? extends Value> elements) {
        super(valueFactory, type, new OrderedSetImpl<Value>(elements));
    }

    public OrderedSetValueImpl(ValueFactory valueFactory, DomainCollectionType type, OrderedSet<Value> elements) {
        super(valueFactory, type, elements);
    }

    @Override
    public OrderedSetValue append(Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "append");
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(this.elements);
        result.remove(object);
        result.add(object);
        return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (OrderedSet<Value>)result);
    }

    @Override
    public OrderedSetValueImpl asOrderedSetValue() {
        return this;
    }

    @Override
    public SequenceValue asSequenceValue() {
        return this;
    }

    @Override
    public UniqueCollectionValue asUniqueCollectionValue() {
        return this;
    }

    @Override
    public Value at(int index) throws InvalidValueException {
        if (--index < 0 || index >= ((OrderedSet)this.elements).size()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        int curr = 0;
        for (Value object : this) {
            if (curr++ != index) continue;
            return object;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OrderedSetValueImpl)) {
            return false;
        }
        return ((OrderedSet)this.elements).equals(((OrderedSetValueImpl)obj).elements);
    }

    @Override
    public OrderedSetValue excluding(Value value) {
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>();
        for (Value element : (OrderedSet)this.elements) {
            if (element.equals(value)) continue;
            result.add(element);
        }
        if (result.size() < ((OrderedSet)this.elements).size()) {
            return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (OrderedSet<Value>)result);
        }
        return this;
    }

    @Override
    public Value first() throws InvalidValueException {
        if (this.elements == null || ((OrderedSet)this.elements).size() <= 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, "OrderedSet", "first");
        }
        return (Value)((OrderedSet)this.elements).iterator().next();
    }

    @Override
    public OrderedSetValue flatten() throws InvalidValueException {
        OrderedSetImpl<Value> flattened = new OrderedSetImpl<Value>();
        if (this.flatten(flattened)) {
            return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (OrderedSet<Value>)flattened);
        }
        return this;
    }

    @Override
    public String getKind() {
        return "OrderedSet";
    }

    @Override
    public OrderedSetValue including(Value value) throws InvalidValueException {
        if (value.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "including");
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(this.elements);
        result.add(value);
        return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (OrderedSet<Value>)result);
    }

    @Override
    public IntegerValue indexOf(Value object) throws InvalidValueException {
        int index = 1;
        for (Value next : (OrderedSet)this.elements) {
            if (object.equals(next)) {
                return this.valueFactory.integerValueOf(index);
            }
            ++index;
        }
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.MissingValue, "indexOf");
        return null;
    }

    @Override
    public OrderedSetValue insertAt(int index, Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "insertAt");
        }
        boolean isContained = ((OrderedSet)this.elements).contains(object);
        int effectiveSize = ((OrderedSet)this.elements).size() - (isContained ? 1 : 0);
        if (--index < 0 || effectiveSize < index) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>();
        int curr = 0;
        Iterator<Value> it = this.iterator();
        while (it.hasNext()) {
            Value next;
            if (curr == index) {
                result.add(object);
            }
            if ((next = it.next()).equals(object)) continue;
            result.add(next);
            ++curr;
        }
        if (index == effectiveSize) {
            result.add(object);
        }
        return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (OrderedSet<Value>)result);
    }

    @Override
    public Value last() throws InvalidValueException {
        if (this.elements == null || ((OrderedSet)this.elements).size() <= 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, "OrderedSet", "last");
        }
        Value result = null;
        Iterator iterator = ((OrderedSet)this.elements).iterator();
        while (iterator.hasNext()) {
            Value next;
            result = next = (Value)iterator.next();
        }
        return result;
    }

    @Override
    public OrderedSetValue minus(UniqueCollectionValue set) throws InvalidValueException {
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(this.elements);
        result.removeAll(set.asCollection());
        return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (OrderedSet<Value>)result);
    }

    @Override
    public OrderedSetValue prepend(Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "prepend");
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>();
        result.add(object);
        result.addAll(this.elements);
        return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (OrderedSet<Value>)result);
    }

    @Override
    public OrderedSetValue reverse() {
        List<Value> elements = this.asList();
        Collections.reverse(elements);
        return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (Collection<? extends Value>)elements);
    }

    @Override
    public OrderedSetValue sort(Comparator<Value> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), values);
    }

    @Override
    public OrderedSetValue subOrderedSet(int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new IndexOutOfBoundsException("lower: " + (lower + 1));
        }
        if (upper >= ((OrderedSet)this.elements).size()) {
            throw new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + this.size());
        }
        if (upper < lower) {
            throw new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1));
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>();
        int curr = 0;
        for (Value object : (OrderedSet)this.elements) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (OrderedSet<Value>)result);
    }

    @Override
    public SequenceValue subSequence(int lower, int upper) throws InvalidValueException {
        return this.subOrderedSet(lower, upper);
    }

    @Override
    public OrderedSetValue symmetricDifference(UniqueCollectionValue set) {
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(this.elements);
        for (Value e : set) {
            if (result.contains(e)) {
                result.remove(e);
                continue;
            }
            result.add(e);
        }
        return new OrderedSetValueImpl(this.valueFactory, this.getCollectionType(), (OrderedSet<Value>)result);
    }

    @Override
    public SequenceValue toSequenceValue() {
        return this;
    }

    @Override
    public void toString(StringBuilder s, int lengthLimit) {
        s.append("OrderedSet");
        super.toString(s, lengthLimit);
    }

    public static class Accumulator
    extends OrderedSetValueImpl
    implements CollectionValue.Accumulator {
        public Accumulator(ValueFactory valueFactory, DomainCollectionType type) {
            super(valueFactory, type, new Value[0]);
        }

        public boolean add(Value value) {
            return ((OrderedSet)this.elements).add(value);
        }
    }
}

