/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.NumericValue;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractValue;

public class UnlimitedValueImpl
extends AbstractValue
implements UnlimitedValue {
    public UnlimitedValueImpl(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public UnlimitedValueImpl abs() {
        return this;
    }

    public Object asObject() {
        return this;
    }

    public Value asValidValue() {
        return this;
    }

    public BigDecimal bigDecimalValue() {
        return null;
    }

    public int compareTo(NumericValue o) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".compareTo");
    }

    public double doubleValue() {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".doubleValue");
    }

    public DomainType getType() {
        return this.valueFactory.getStandardLibrary().getUnlimitedNaturalType();
    }

    public boolean isUnlimited() {
        return true;
    }

    public boolean isUnlimitedNatural() {
        return true;
    }

    public UnlimitedValue negate() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidOperation, "negate", "UnlimitedValue");
        return null;
    }

    public int signum() {
        return 1;
    }

    public String toString() {
        return "*";
    }
}

