/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.ui.registrations;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseFileHandle;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.examples.modelregistry.environment.ProjectHandle;
import org.eclipse.ocl.examples.modelregistry.model.Accessor;
import org.eclipse.ocl.examples.modelregistry.model.AccessorRegistry;
import org.eclipse.ocl.examples.modelregistry.model.FileHandleRegistry;
import org.eclipse.ocl.examples.modelregistry.model.ProjectRegistry;
import org.eclipse.ocl.examples.modelregistry.model.Registration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationsContentProvider
implements ITreeContentProvider {
    protected IProject project = null;
    private EclipseProjectHandle projectHandle = null;
    protected ProjectRegistry projectRegistry = null;

    public void dispose() {
    }

    public Object[] getElements(Object selection) {
        System.out.println("getElements of " + selection);
        if (this.project == null || !(selection instanceof IResource)) {
            return new Object[0];
        }
        IResource resource = (IResource)selection;
        int depth = 0;
        IResource res = resource;
        while (res != null) {
            ++depth;
            if (res instanceof IProject) break;
            res = res.getParent();
        }
        Object[] objects = new Object[depth];
        depth = 0;
        IResource res2 = resource;
        while (res2 != null) {
            if (res2 instanceof IProject) {
                objects[depth++] = this.projectHandle;
                break;
            }
            EclipseFileHandle fileHandle = this.projectHandle.getFileHandle(res2);
            objects[depth++] = fileHandle;
            res2 = res2.getParent();
        }
        return objects;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof FileHandle) {
            FileHandleRegistry fileHandleRegistry = this.projectRegistry.get((FileHandle)element);
            Collection accessorRegistries = fileHandleRegistry.getRegistries();
            Object[] entries = new AccessorRegistry[accessorRegistries.size()];
            int i = 0;
            for (AccessorRegistry accessorRegistry : accessorRegistries) {
                entries[i++] = accessorRegistry;
            }
            return entries;
        }
        if (element instanceof AccessorRegistry) {
            return this.getAccessorChildren((AccessorRegistry)element);
        }
        return new String[]{"A", "B"};
    }

    protected <A extends Accessor<A>> Object[] getAccessorChildren(AccessorRegistry<A> accessorRegistry) {
        Collection registrations = accessorRegistry.getRegistrations();
        Object[] entries = new Registration[registrations.size()];
        int i = 0;
        for (Registration registration : registrations) {
            entries[i++] = registration;
        }
        return entries;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.project == null) {
            return false;
        }
        if (element instanceof FileHandle) {
            FileHandleRegistry fileHandleRegistry = this.projectRegistry.get((FileHandle)element);
            if (fileHandleRegistry == null) {
                return false;
            }
            Collection accessorRegistries = fileHandleRegistry.getRegistries();
            return accessorRegistries.size() > 0;
        }
        if (element instanceof AccessorRegistry) {
            AccessorRegistry accessorRegistry = (AccessorRegistry)element;
            return accessorRegistry.getRegistrations().size() > 0;
        }
        return false;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        System.out.println("inputChanged to " + newInput);
        IResource resource = null;
        if (newInput instanceof IResource) {
            resource = (IResource)newInput;
        } else if (newInput instanceof IAdaptable) {
            resource = (IResource)((IAdaptable)newInput).getAdapter(IResource.class);
        }
        if (resource == null) {
            this.project = null;
            return;
        }
        this.project = resource.getProject();
        if (this.projectHandle != null && this.project == this.projectHandle.getProjectResource()) {
            return;
        }
        this.projectHandle = new EclipseProjectHandle(this.project);
        this.projectRegistry = new ProjectRegistry((ProjectHandle)this.projectHandle);
        this.projectRegistry.loadModel();
    }
}

