/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.eclipse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseFileHandle;
import org.eclipse.ocl.examples.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.ocl.examples.modelregistry.environment.ProjectHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseProjectHandle
extends EclipseFileHandle
implements ProjectHandle {
    private Map<IResource, EclipseFileHandle> handles = new HashMap<IResource, EclipseFileHandle>();
    private List<String> registryNames = new ArrayList<String>();
    private URI uri = null;

    public EclipseProjectHandle(IProject project) {
        super(project);
        this.registryNames.add(".settings/org.eclipse.ocl.modelregistry");
        this.registryNames.add(".settings/org.eclipse.qvt.declarative.modelregistry");
        this.handles.put((IResource)project, this);
    }

    @Override
    public EclipseFileHandle getFileHandle(String name) {
        IResource memberResource;
        Path path = new Path(name);
        IProject referenceResource = this.getProjectResource();
        if (path.isAbsolute()) {
            path = path.makeRelative();
            referenceResource = referenceResource.getParent();
        }
        if ((memberResource = referenceResource.findMember((IPath)path)) != null) {
            return this.getFileHandle(memberResource);
        }
        IFile fileResource = referenceResource.getFile((IPath)path);
        if (fileResource != null) {
            return this.getFileHandle((IResource)fileResource);
        }
        return null;
    }

    public EclipseFileHandle getFileHandle(IResource resource) {
        if (resource == null) {
            return null;
        }
        EclipseFileHandle handle = this.handles.get(resource);
        if (handle == null) {
            handle = new EclipseFileHandle(this, resource);
            this.handles.put(resource, handle);
        }
        return handle;
    }

    public IProject getProjectResource() {
        return (IProject)this.getResource();
    }

    public IFile getRegistryResource() {
        return this.getProjectResource().getFile((IPath)new Path(this.getRegistryName()));
    }

    @Override
    public URI getRegistryURI() {
        if (this.registryNames.isEmpty()) {
            return null;
        }
        URI registryURI = URI.createURI((String)this.registryNames.get(0), (boolean)false);
        URI projectURI = this.getURI();
        URI resolvedURI = registryURI.resolve(projectURI);
        return resolvedURI;
    }

    @Override
    public List<URI> getRegistryURIs() {
        ArrayList<URI> registryURIs = new ArrayList<URI>();
        for (String registryName : this.registryNames) {
            URI registryURI = URI.createURI((String)registryName, (boolean)false);
            URI projectURI = this.getURI();
            URI resolvedURI = registryURI.resolve(projectURI);
            registryURIs.add(resolvedURI);
        }
        return registryURIs;
    }

    @Override
    public String getRegistryName() {
        return this.registryNames.get(0);
    }

    public List<String> getRegistryNames() {
        return this.registryNames;
    }

    @Override
    public URI getURI() {
        if (this.uri == null) {
            this.uri = URI.createPlatformResourceURI((String)(String.valueOf(this.resource.getFullPath().toString()) + "/"), (boolean)true);
        }
        return this.uri;
    }

    @Override
    public void refreshRegistry() {
        IFile registryResource = this.getRegistryResource();
        try {
            registryResource.refreshLocal(0, null);
        }
        catch (CoreException e) {
            ModelRegistryEnvironment.logError("Failed to refresh registry", e);
        }
    }

    @Override
    public void setRegistryName(String name) {
        this.registryNames = Collections.singletonList(name);
    }

    public void setRegistryNames(List<String> names) {
        this.registryNames = new ArrayList<String>(names);
    }
}

