/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.environment;

import org.eclipse.ocl.examples.common.utils.ClassUtils;
import org.eclipse.ocl.examples.modelregistry.environment.ModelRegistryEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassDelegate<T> {
    protected final String className;
    protected final Class<T> clazz;
    private T instance = null;
    private boolean loaded = false;

    public ClassDelegate(String className, Class<T> clazz) {
        this.className = className;
        this.clazz = clazz;
    }

    public ClassDelegate(T instance) {
        this.className = instance.getClass().getName();
        this.clazz = ClassUtils.getClass(instance);
        this.instance = instance;
        this.loaded = true;
    }

    public T load() {
        if (this.instance == null && !this.loaded) {
            this.loaded = true;
            try {
                Class<?> loadedClass = this.loadClass(this.className);
                if (!this.clazz.isAssignableFrom(loadedClass)) {
                    throw new ClassCastException("model_content extension requires " + loadedClass.getName() + " to be assignable to " + this.clazz.getName());
                }
                this.instance = loadedClass.newInstance();
            }
            catch (Exception e) {
                ModelRegistryEnvironment.logError("Failed to load model content '" + this.className + "'", e);
            }
        }
        return this.instance;
    }

    protected abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    public String toString() {
        return this.className;
    }
}

