/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.attributes;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.scoping.AbstractAttribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.ValidationDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ImportCSAttribution
extends AbstractAttribution
implements CS2Pivot.UnresolvedProxyMessageProvider {
    public static final ImportCSAttribution INSTANCE = new ImportCSAttribution();

    public ScopeView computeLookup(EObject target, EnvironmentView environmentView, ScopeView scopeView) {
        ImportCS targetElement = (ImportCS)target;
        ImportAdapter adapter = (ImportAdapter)((Object)PivotUtil.getAdapter(ImportAdapter.class, (Notifier)targetElement));
        if (adapter == null) {
            adapter = new ImportAdapter();
            targetElement.eAdapters().add((Object)adapter);
        }
        return adapter.computeLookup(targetElement, environmentView, scopeView);
    }

    public EReference getEReference() {
        return BaseCSTPackage.Literals.IMPORT_CS__NAMESPACE;
    }

    public String getMessage(EObject context, String linkText) {
        ImportAdapter adapter = (ImportAdapter)((Object)PivotUtil.getAdapter(ImportAdapter.class, (Notifier)context));
        if (adapter != null) {
            String message = adapter.getMessage();
            return NLS.bind((String)OCLMessages.UnresolvedImport_ERROR_, (Object)linkText, (Object)message);
        }
        return null;
    }

    private static class ImportAdapter
    extends AdapterImpl {
        private URI uri = null;
        private Element importedElement = null;
        private Throwable throwable = null;

        private ImportAdapter() {
        }

        public ScopeView computeLookup(ImportCS targetElement, EnvironmentView environmentView, ScopeView scopeView) {
            EReference targetReference = scopeView.getTargetReference();
            if (targetReference == BaseCSTPackage.Literals.IMPORT_CS__NAMESPACE) {
                Resource importedResource;
                EList errors;
                String name = environmentView.getName();
                if (name != null) {
                    this.importModel(targetElement, environmentView);
                }
                if (this.importedElement != null && (errors = (importedResource = this.importedElement.eResource()).getErrors()).size() == 0) {
                    environmentView.addElement(name, (EObject)this.importedElement);
                }
                return null;
            }
            EStructuralFeature containmentFeature = scopeView.getContainmentFeature();
            if (containmentFeature == null) {
                environmentView.addElementsOfScope(this.importedElement, scopeView);
            } else {
                environmentView.addElementsOfScope(this.importedElement, scopeView);
            }
            return scopeView.getParent();
        }

        public String getMessage() {
            return this.throwable != null ? this.throwable.getMessage() : null;
        }

        protected void importModel(ImportCS target, EnvironmentView environmentView) {
            String name = environmentView.getName();
            if (name == null) {
                return;
            }
            BaseCSResource csResource = (BaseCSResource)target.eResource();
            try {
                URI newURI = URI.createURI((String)name);
                newURI = csResource.resolve(newURI);
                if (newURI.equals((Object)this.uri)) {
                    return;
                }
                this.uri = newURI;
                this.importedElement = null;
                this.throwable = null;
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
                return;
            }
            catch (Exception e) {
                this.throwable = e;
                return;
            }
            try {
                EList errors;
                MetaModelManager metaModelManager = environmentView.getMetaModelManager();
                this.importedElement = metaModelManager.loadResource(this.uri, target.getName(), null);
                Resource importedResource = this.importedElement.eResource();
                EList warnings = importedResource.getWarnings();
                if (warnings.size() > 0) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                    String errorMessage = PivotUtil.formatResourceDiagnostics((List)warnings, (String)NLS.bind((String)OCLMessages.WarningsInURI, (Object)this.uri), (String)"\n\t");
                    ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                    csResource.getWarnings().add((Object)resourceDiagnostic);
                }
                if ((errors = importedResource.getErrors()).size() > 0) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                    String errorMessage = PivotUtil.formatResourceDiagnostics((List)errors, (String)NLS.bind((String)OCLMessages.ErrorsInURI, (Object)this.uri), (String)"\n\t");
                    ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                    csResource.getErrors().add((Object)resourceDiagnostic);
                }
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
            }
            catch (Exception e) {
                this.throwable = e;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == ImportAdapter.class;
        }
    }
}

