/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.attributes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.library.StandardLibraryContribution;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.scoping.AbstractAttribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.LibraryCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.ValidationDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class LibraryCSAttribution
extends AbstractAttribution
implements CS2Pivot.UnresolvedProxyMessageProvider {
    public static final LibraryCSAttribution INSTANCE = new LibraryCSAttribution();

    public ScopeView computeLookup(EObject target, EnvironmentView environmentView, ScopeView scopeView) {
        LibraryCS targetElement = (LibraryCS)target;
        LibraryAdapter adapter = (LibraryAdapter)((Object)PivotUtil.getAdapter(LibraryAdapter.class, (Notifier)targetElement));
        if (adapter == null) {
            adapter = new LibraryAdapter();
            targetElement.eAdapters().add((Object)adapter);
        }
        return adapter.computeLookup(targetElement, environmentView, scopeView);
    }

    public EReference getEReference() {
        return BaseCSTPackage.Literals.LIBRARY_CS__PACKAGE;
    }

    public String getMessage(EObject context, String linkText) {
        LibraryAdapter adapter = (LibraryAdapter)((Object)PivotUtil.getAdapter(LibraryAdapter.class, (Notifier)context));
        if (adapter != null) {
            String message = adapter.getMessage();
            return NLS.bind((String)OCLMessages.UnresolvedLibrary_ERROR_, (Object)linkText, (Object)message);
        }
        return null;
    }

    private static class LibraryAdapter
    extends AdapterImpl {
        private URI uri = null;
        private Element importedElement = null;
        private Throwable throwable = null;

        private LibraryAdapter() {
        }

        public ScopeView computeLookup(LibraryCS targetElement, EnvironmentView environmentView, ScopeView scopeView) {
            EReference targetReference = scopeView.getTargetReference();
            if (targetReference == BaseCSTPackage.Literals.LIBRARY_CS__PACKAGE) {
                Resource importedResource;
                EList errors;
                String name = environmentView.getName();
                if (name != null) {
                    this.importLibrary(targetElement, environmentView);
                }
                if (this.importedElement != null && (errors = (importedResource = this.importedElement.eResource()).getErrors()).size() == 0) {
                    environmentView.addElement(name, (EObject)this.importedElement);
                }
                return null;
            }
            EStructuralFeature containmentFeature = scopeView.getContainmentFeature();
            if (containmentFeature == null) {
                environmentView.addElementsOfScope(this.importedElement, scopeView);
            } else {
                environmentView.addElementsOfScope(this.importedElement, scopeView);
            }
            return scopeView.getParent();
        }

        public String getMessage() {
            return this.throwable != null ? this.throwable.getMessage() : null;
        }

        protected void importLibrary(LibraryCS target, EnvironmentView environmentView) {
            String name = environmentView.getName();
            if (name == null) {
                return;
            }
            StandardLibraryContribution contribution = (StandardLibraryContribution)StandardLibraryContribution.REGISTRY.get((Object)name);
            if (contribution != null) {
                Resource resource = contribution.getResource();
                try {
                    MetaModelManager metaModelManager = environmentView.getMetaModelManager();
                    metaModelManager.loadLibrary(resource);
                    environmentView.addElement(name, (EObject)resource.getContents().get(0));
                }
                catch (IllegalLibraryException e) {
                    this.throwable = e;
                }
                return;
            }
            BaseCSResource csResource = (BaseCSResource)target.eResource();
            try {
                URI newURI = URI.createURI((String)name);
                newURI = csResource.resolve(newURI);
                if (newURI.equals((Object)this.uri)) {
                    return;
                }
                this.uri = newURI;
                this.importedElement = null;
                this.throwable = null;
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
                return;
            }
            catch (Exception e) {
                this.throwable = e;
                return;
            }
            ArrayList<Element> importedElements = new ArrayList<Element>();
            ResourceSet csResourceSet = csResource.getResourceSet();
            MetaModelManager metaModelManager = environmentView.getMetaModelManager();
            MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)csResourceSet, (MetaModelManager)metaModelManager);
            try {
                EList errors;
                EList warnings;
                Resource importedResource = csResourceSet.getResource(this.uri, true);
                EList contents = importedResource.getContents();
                if (contents.size() > 0) {
                    for (EObject content : contents) {
                        if (!(content instanceof Pivotable)) continue;
                        Element pivot = ((Pivotable)content).getPivot();
                        importedElements.add(pivot);
                        if (this.importedElement != null) continue;
                        this.importedElement = pivot;
                    }
                }
                if ((warnings = importedResource.getWarnings()).size() > 0) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                    String errorMessage = PivotUtil.formatResourceDiagnostics((List)warnings, (String)NLS.bind((String)OCLMessages.WarningsInURI, (Object)this.uri), (String)"\n\t");
                    ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                    csResource.getWarnings().add((Object)resourceDiagnostic);
                }
                if ((errors = importedResource.getErrors()).size() > 0) {
                    Resource.Diagnostic diagnostic = (Resource.Diagnostic)errors.get(0);
                    if (diagnostic instanceof WrappedException) {
                        this.throwable = ((WrappedException)diagnostic).exception();
                    } else {
                        ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                        String errorMessage = PivotUtil.formatResourceDiagnostics((List)errors, (String)("Errors in '" + this.uri + "'"), (String)"\n\t");
                        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                        csResource.getErrors().add((Object)resourceDiagnostic);
                    }
                }
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
            }
            catch (Exception e) {
                this.throwable = e;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == LibraryAdapter.class;
        }
    }
}

