/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.TupleTypeManager;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DataTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DocumentationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.EnumerationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.EnumerationLiteralCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.LambdaTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MultiplicityBoundsCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MultiplicityStringCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PivotableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.StructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TuplePartCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TupleTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuations;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.PivotDependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.PivotHasSuperClassesDependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.SingleContinuation;
import org.eclipse.ocl.examples.xtext.base.util.AbstractExtendingBaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePreOrderVisitor
extends AbstractExtendingBaseCSVisitor<Continuation<?>, CS2PivotConversion> {
    public BasePreOrderVisitor(CS2PivotConversion context) {
        super(context);
    }

    @Override
    public Continuation<?> visiting(VisitableCS visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for CS2Pivot PreOrder pass");
    }

    @Override
    public Continuation<?> visitAnnotationCS(AnnotationCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitClassCS(ClassCS csClass) {
        Class pivotElement = (Class)PivotUtil.getPivot(Class.class, (Pivotable)csClass);
        Continuations continuations = new Continuations();
        if (csClass.getOwnedTemplateSignature() != null) {
            continuations.add(new TemplateSignatureContinuation((CS2PivotConversion)((Object)this.context), (NamedElement)pivotElement, csClass));
        } else {
            pivotElement.setOwnedTemplateSignature(null);
        }
        if (!(pivotElement instanceof AnyType)) {
            continuations.add(new ClassSupersContinuation((CS2PivotConversion)((Object)this.context), pivotElement, csClass));
        }
        return continuations.getContinuation();
    }

    @Override
    public Continuation<?> visitConstraintCS(ConstraintCS csConstraint) {
        return null;
    }

    @Override
    public Continuation<?> visitDataTypeCS(DataTypeCS csDataType) {
        return null;
    }

    @Override
    public Continuation<?> visitDocumentationCS(DocumentationCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationCS(EnumerationCS csEnumeration) {
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationLiteralCS(EnumerationLiteralCS csEnumerationLiteral) {
        return null;
    }

    @Override
    public Continuation<?> visitLambdaTypeCS(LambdaTypeCS csLambdaType) {
        return new LambdaContinuation((CS2PivotConversion)((Object)this.context), csLambdaType);
    }

    @Override
    public Continuation<?> visitModelElementCS(ModelElementCS csModelElement) {
        return null;
    }

    @Override
    public Continuation<?> visitModelElementRefCS(ModelElementRefCS csModelElementRef) {
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityBoundsCS(MultiplicityBoundsCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityStringCS(MultiplicityStringCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitOperationCS(OperationCS csOperation) {
        return null;
    }

    @Override
    public Continuation<?> visitPackageCS(PackageCS csPackage) {
        return null;
    }

    @Override
    public Continuation<?> visitPathElementCS(PathElementCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPathNameCS(PathNameCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrimitiveTypeRefCS(PrimitiveTypeRefCS csPrimitiveTypeRef) {
        return new PrimitiveTypeRefContinuation((CS2PivotConversion)((Object)this.context), csPrimitiveTypeRef);
    }

    @Override
    public Continuation<?> visitStructuralFeatureCS(StructuralFeatureCS csStructuralFeature) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateBindingCS(TemplateBindingCS csTemplateBinding) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateSignatureCS(TemplateSignatureCS csTemplateSignature) {
        return null;
    }

    @Override
    public Continuation<?> visitTupleTypeCS(TupleTypeCS csTupleType) {
        return new TupleContinuation((CS2PivotConversion)((Object)this.context), csTupleType);
    }

    @Override
    public Continuation<?> visitTypedTypeRefCS(TypedTypeRefCS csTypedTypeRef) {
        if (csTypedTypeRef.getOwnedTemplateBinding() == null) {
            return new UnspecializedTypeRefContinuation((CS2PivotConversion)((Object)this.context), csTypedTypeRef);
        }
        return new SpecializedTypeRefContinuation1((CS2PivotConversion)((Object)this.context), csTypedTypeRef);
    }

    @Override
    public Continuation<?> visitWildcardTypeRefCS(WildcardTypeRefCS csWildcardTypeRef) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassSupersContinuation
    extends SingleContinuation<ClassCS> {
        private static Dependency[] computeDependencies(CS2PivotConversion context, ClassCS csElement) {
            EList<TypedRefCS> csSuperTypes = csElement.getOwnedSuperType();
            if (csSuperTypes.isEmpty()) {
                return null;
            }
            ArrayList<PivotDependency> dependencies = new ArrayList<PivotDependency>();
            for (TypedRefCS csSuperType : csSuperTypes) {
                dependencies.add(new PivotDependency(csSuperType));
            }
            return dependencies.toArray(new Dependency[dependencies.size()]);
        }

        public ClassSupersContinuation(CS2PivotConversion context, Class pivotParent, ClassCS csElement) {
            super(context, (Element)pivotParent, null, csElement, ClassSupersContinuation.computeDependencies(context, csElement));
        }

        @Override
        public BasicContinuation<?> execute() {
            Class oclElementType;
            Class pivotElement = (Class)PivotUtil.getPivot(Class.class, (Pivotable)((Pivotable)this.csElement));
            EList superClasses = pivotElement.getSuperClass();
            this.context.refreshList(Type.class, superClasses, (List<? extends PivotableElementCS>)((ClassCS)this.csElement).getOwnedSuperType());
            if (superClasses.isEmpty() && (oclElementType = this.context.getMetaModelManager().getOclElementType()) != null) {
                pivotElement.getSuperClass().add((Object)oclElementType);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LambdaContinuation
    extends SingleContinuation<LambdaTypeCS> {
        private static Dependency[] computeDependencies(CS2PivotConversion context, LambdaTypeCS csElement) {
            EList<TypedRefCS> csParameterTypes = csElement.getOwnedParameterType();
            int iMax = csParameterTypes.size();
            Dependency[] dependencies = new Dependency[2 + iMax];
            dependencies[0] = context.createTypeIsReferenceableDependency(csElement.getOwnedContextType());
            dependencies[1] = context.createTypeIsReferenceableDependency(csElement.getOwnedResultType());
            int i = 0;
            while (i < iMax) {
                TypedRefCS csParameterType = (TypedRefCS)csParameterTypes.get(i);
                dependencies[i + 2] = context.createTypeIsReferenceableDependency(csParameterType);
                ++i;
            }
            return dependencies;
        }

        public LambdaContinuation(CS2PivotConversion context, LambdaTypeCS csElement) {
            super(context, null, null, csElement, LambdaContinuation.computeDependencies(context, csElement));
        }

        @Override
        public BasicContinuation<?> execute() {
            Type contextType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((LambdaTypeCS)this.csElement).getOwnedContextType());
            Type resultType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((LambdaTypeCS)this.csElement).getOwnedResultType());
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            for (TypedRefCS csParameterType : ((LambdaTypeCS)this.csElement).getOwnedParameterType()) {
                Type parameterType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csParameterType);
                parameterTypes.add(parameterType);
            }
            LambdaType lambdaType = this.context.getMetaModelManager().getLambdaType(((LambdaTypeCS)this.csElement).getName(), contextType, parameterTypes, resultType, null);
            this.context.installPivotReference((ElementRefCS)this.csElement, (Element)lambdaType, BaseCSTPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrimitiveTypeRefContinuation
    extends SingleContinuation<PrimitiveTypeRefCS> {
        public PrimitiveTypeRefContinuation(CS2PivotConversion context, PrimitiveTypeRefCS csElement) {
            super(context, null, null, csElement, new Dependency[0]);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type type = this.context.getMetaModelManager().getLibraryType(((PrimitiveTypeRefCS)this.csElement).getName());
            this.context.installPivotReference((ElementRefCS)this.csElement, (Element)type, BaseCSTPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SpecializedTypeRefContinuation1
    extends SingleContinuation<TypedTypeRefCS> {
        public SpecializedTypeRefContinuation1(CS2PivotConversion context, TypedTypeRefCS csElement) {
            super(context, null, null, csElement, context.getTypesHaveSignaturesInterDependency());
            assert (csElement.getOwnedTemplateBinding() != null);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getType();
            return new SpecializedTypeRefContinuation2(this.context, (TypedTypeRefCS)this.csElement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SpecializedTypeRefContinuation2
    extends SingleContinuation<TypedTypeRefCS> {
        private static Dependency[] computeDependencies(CS2PivotConversion context, TypedTypeRefCS csElement) {
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            TemplateBindingCS csTemplateBinding = csElement.getOwnedTemplateBinding();
            if (csTemplateBinding != null) {
                for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedParameterSubstitution()) {
                    TypeRefCS csTemplateParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                    Dependency dependency = context.createTypeIsReferenceableDependency(csTemplateParameter);
                    if (dependency == null) continue;
                    dependencies.add(dependency);
                }
                for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedParameterSubstitution()) {
                    TypeRefCS csActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                    dependencies.add(new PivotDependency(csActualParameter));
                }
            }
            dependencies.add(new PivotHasSuperClassesDependency(csElement));
            return dependencies.toArray(new Dependency[dependencies.size()]);
        }

        public SpecializedTypeRefContinuation2(CS2PivotConversion context, TypedTypeRefCS csElement) {
            super(context, null, null, csElement, SpecializedTypeRefContinuation2.computeDependencies(context, csElement));
            assert (csElement.getOwnedTemplateBinding() != null);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getType();
            if (pivotType != null) {
                TemplateBindingCS csTemplateBinding = ((TypedTypeRefCS)this.csElement).getOwnedTemplateBinding();
                if (ElementUtil.isSpecialization(csTemplateBinding)) {
                    pivotType = this.context.specializeTemplates((TypedTypeRefCS)this.csElement);
                }
                this.context.installPivotReference((ElementRefCS)this.csElement, (Element)pivotType, BaseCSTPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TemplateSignatureContinuation
    extends SingleContinuation<ClassifierCS> {
        public TemplateSignatureContinuation(CS2PivotConversion context, NamedElement pivotParent, ClassifierCS csElement) {
            super(context, (Element)pivotParent, (EStructuralFeature)PivotPackage.Literals.TEMPLATEABLE_ELEMENT__OWNED_TEMPLATE_SIGNATURE, csElement, new Dependency[0]);
            context.getTypesHaveSignaturesInterDependency().addDependency(this);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotElement = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((Pivotable)this.csElement));
            this.context.refreshTemplateSignature((TemplateableElementCS)this.csElement, (TemplateableElement)pivotElement);
            this.context.getTypesHaveSignaturesInterDependency().setSatisfied(this);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TupleContinuation
    extends SingleContinuation<TupleTypeCS> {
        public TupleContinuation(CS2PivotConversion context, TupleTypeCS csElement) {
            super(context, null, null, csElement, new Dependency[0]);
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                TypedRefCS ownedType = csTuplePart.getOwnedType();
                if (ownedType.getPivot() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public BasicContinuation<?> execute() {
            ArrayList<TupleTypeManager.TuplePart> tupleParts = new ArrayList<TupleTypeManager.TuplePart>();
            for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                Type partType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTuplePart.getOwnedType());
                TupleTypeManager.TuplePart tuplePart = new TupleTypeManager.TuplePart(csTuplePart.getName(), partType);
                tupleParts.add(tuplePart);
                this.context.installPivotUsage(csTuplePart, (Element)tuplePart);
            }
            TupleType tupleType = this.context.getMetaModelManager().getTupleType(((TupleTypeCS)this.csElement).getName(), tupleParts, null);
            this.context.installPivotReference((ElementRefCS)this.csElement, (Element)tupleType, BaseCSTPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnspecializedTypeRefContinuation
    extends SingleContinuation<TypedTypeRefCS> {
        public UnspecializedTypeRefContinuation(CS2PivotConversion context, TypedTypeRefCS csElement) {
            super(context, null, null, csElement, context.getTypesHaveSignaturesInterDependency());
            assert (csElement.getOwnedTemplateBinding() == null);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getType();
            if (pivotType != null) {
                this.context.installPivotReference((ElementRefCS)this.csElement, (Element)pivotType, BaseCSTPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
            }
            return null;
        }
    }
}

