/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.common.utils.TracingOption;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.context.AbstractBase2PivotConversion;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.MorePivotable;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PivotableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasePreOrderVisitor;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.InterDependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.PivotDependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.ValidationDiagnostic;
import org.eclipse.ocl.examples.xtext.base.util.BaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2Moniker;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CS2PivotConversion
extends AbstractBase2PivotConversion {
    private static final Logger logger = Logger.getLogger(CS2PivotConversion.class);
    public static final TracingOption CONTINUATION = new TracingOption("org.eclipse.ocl.examples.xtext.base", "continuation");
    protected final CS2Pivot converter;
    protected final Collection<? extends Resource> csResources;
    private final BaseCSVisitor<Continuation<?>> containmentVisitor;
    private final BaseCSVisitor<Element> left2RightVisitor;
    private final BaseCSVisitor<Continuation<?>> postOrderVisitor;
    private final BaseCSVisitor<Continuation<?>> preOrderVisitor;
    private InterDependency<BasePreOrderVisitor.TemplateSignatureContinuation> typesHaveSignatures = new InterDependency("All unspecialized signatures defined", null);
    private final Map<CacheKey<?>, Object> intermediateCache = new HashMap();
    private Map<String, Package> oldPackagesByName = null;
    private Map<String, Package> oldPackagesByQualifiedName = null;
    private final IDiagnosticConsumer diagnosticsConsumer;

    public CS2PivotConversion(CS2Pivot converter, IDiagnosticConsumer diagnosticsConsumer, Collection<? extends Resource> csResources) {
        super(converter.getMetaModelManager());
        this.converter = converter;
        this.diagnosticsConsumer = diagnosticsConsumer;
        this.csResources = csResources;
        this.containmentVisitor = converter.createContainmentVisitor(this);
        this.left2RightVisitor = converter.createLeft2RightVisitor(this);
        this.postOrderVisitor = converter.createPostOrderVisitor(this);
        this.preOrderVisitor = converter.createPreOrderVisitor(this);
        ArrayList<Resource> mappedResources = new ArrayList<Resource>();
        for (Resource resource : csResources) {
            mappedResources.add(converter.getPivotResource(resource));
        }
    }

    public OCLExpression addBadExpressionError(ModelElementCS csElement, String boundMessage) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
        InvalidLiteralExp invalidLiteralExp = this.metaModelManager.createInvalidExpression();
        csElement.setPivot((Element)invalidLiteralExp);
        return invalidLiteralExp;
    }

    public void addDiagnostic(ModelElementCS csElement, Diagnostic diagnostic) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, diagnostic.getMessage());
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    public void addDiagnostic(ElementCS csElement, String boundMessage) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    public void addWarning(ModelElementCS csElement, String message, Object ... bindings) {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    public String bind(EObject csContext, String messageTemplate, Object ... bindings) {
        return this.converter.bind(csContext, messageTemplate, bindings);
    }

    public boolean checkForNoErrors(Collection<? extends Resource> csResources) {
        for (Resource resource : csResources) {
            if (!ElementUtil.hasSyntaxError((List<Resource.Diagnostic>)resource.getErrors())) continue;
            return false;
        }
        return true;
    }

    public Dependency createTypeIsReferenceableDependency(TypeRefCS csTemplateParameter) {
        if (csTemplateParameter == null || csTemplateParameter instanceof WildcardTypeRefCS) {
            return null;
        }
        return new PivotDependency(csTemplateParameter);
    }

    protected void diagnoseContinuationFailure(List<BasicContinuation<?>> continuations) {
        if (CONTINUATION.isActive()) {
            for (BasicContinuation<?> continuation : continuations) {
                CONTINUATION.println(continuation.toString());
                Dependency[] dependencyArray = continuation.getDependencies();
                int n = dependencyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Dependency dependency = dependencyArray[n2];
                    boolean canExecute = dependency.canExecute();
                    CONTINUATION.println(String.valueOf(canExecute ? "+ " : "- ") + dependency.toString());
                    ++n2;
                }
            }
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        for (BasicContinuation<?> continuation : continuations) {
            s.append("\n  ");
            s.append(continuation);
            Dependency[] dependencyArray = continuation.getDependencies();
            int n = dependencyArray.length;
            int n3 = 0;
            while (n3 < n) {
                Dependency dependency = dependencyArray[n3];
                s.append("\n    ");
                if (!dependency.canExecute()) {
                    s.append("BLOCKED ");
                    dependency.canExecute();
                }
                s.append(dependency);
                ++n3;
            }
            continuation.canExecute();
            if (++i < 10) continue;
            s.append("\n  ...");
            break;
        }
        logger.error((Object)("Failed to complete continuations" + s.toString()));
    }

    public void garbageCollect(Map<? extends Resource, ? extends Resource> cs2pivotResourceMap) {
        Object eObject;
        Object referencedOrphan;
        final ArrayList<? extends Resource> prunableResources = new ArrayList<Resource>(cs2pivotResourceMap.values());
        ArrayList<Object> allPivotResources = new ArrayList<Object>((Collection<Object>)this.metaModelManager.getPivotResourceSet().getResources());
        EObject lockingObject = this.metaModelManager.getLockingObject();
        if (lockingObject != null) {
            allPivotResources.add(lockingObject);
        }
        allPivotResources.addAll(this.metaModelManager.getLibraries());
        allPivotResources.addAll(cs2pivotResourceMap.keySet());
        EcoreUtil.CrossReferencer referencesToOrphans = new EcoreUtil.CrossReferencer(allPivotResources){
            {
                super($anonymous0);
                this.crossReference();
            }

            protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
                Resource eResource = crossReferencedEObject.eResource();
                boolean isPrunable = prunableResources.contains(eResource);
                return isPrunable;
            }

            protected void handleCrossReference(EObject eObject) {
                try {
                    super.handleCrossReference(eObject);
                    InternalEObject internalEObject = (InternalEObject)eObject;
                    for (EObject eContent : eObject.eContents()) {
                        EReference eReference = (EReference)eContent.eContainingFeature();
                        this.add(internalEObject, eReference, eContent);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            protected boolean resolve() {
                return false;
            }
        };
        HashSet<Object> wantedOrphans = new HashSet<Object>();
        ArrayList<Map.Entry> suspects = new ArrayList<Map.Entry>();
        for (Map.Entry entry : referencesToOrphans.entrySet()) {
            referencedOrphan = (EObject)entry.getKey();
            Collection referencesToOrphan = (Collection)entry.getValue();
            boolean wantIt = false;
            for (EStructuralFeature.Setting setting : referencesToOrphan) {
                eObject = setting.getEObject();
                Resource eResource = eObject.eResource();
                if (prunableResources.contains(eResource)) continue;
                wantedOrphans.add(referencedOrphan);
                wantIt = true;
                break;
            }
            if (wantIt) continue;
            suspects.add(entry);
        }
        while (!suspects.isEmpty()) {
            ArrayList<Map.Entry> arrayList = suspects;
            suspects = new ArrayList();
            for (Map.Entry entry : arrayList) {
                EObject referencedOrphan2 = (EObject)entry.getKey();
                Collection referencesToOrphan = (Collection)entry.getValue();
                boolean wantIt = false;
                for (EStructuralFeature.Setting setting : referencesToOrphan) {
                    EObject eObject2 = setting.getEObject();
                    if (!wantedOrphans.contains(eObject2)) continue;
                    wantedOrphans.add(referencedOrphan2);
                    wantIt = true;
                    break;
                }
                if (wantIt) continue;
                suspects.add(entry);
            }
            if (arrayList.size() <= suspects.size()) break;
        }
        for (Map.Entry entry : suspects) {
            EObject eContainer;
            referencedOrphan = (EObject)entry.getKey();
            boolean wantIt = false;
            for (EObject eChild : referencedOrphan.eContents()) {
                if (!wantedOrphans.contains(eChild)) continue;
                wantIt = true;
                break;
            }
            if (wantIt) continue;
            Collection referencesToOrphan = (Collection)entry.getValue();
            if (referencesToOrphan != null) {
                for (EStructuralFeature.Setting setting : referencesToOrphan) {
                    eObject = setting.getEObject();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    if (eStructuralFeature.isDerived()) continue;
                    if (eStructuralFeature.isMany()) {
                        Collection list = (Collection)eObject.eGet(eStructuralFeature);
                        list.remove(referencedOrphan);
                        continue;
                    }
                    eObject.eSet(eStructuralFeature, null);
                }
            }
            if ((eContainer = referencedOrphan.eContainer()) == null) continue;
            PivotUtil.debugObjectUsage((String)"  container ", (EObject)eContainer);
            referencedOrphan.eSet(referencedOrphan.eContainingFeature(), null);
        }
    }

    protected void gatherNewPackage(Set<Package> newPackages, EObject pivot) {
        EObject eContainer;
        if (pivot instanceof Package) {
            newPackages.add((Package)pivot);
        }
        if ((eContainer = pivot.eContainer()) != null) {
            this.gatherNewPackage(newPackages, eContainer);
        }
    }

    protected void gatherNewPackages(Set<Package> newPackages, Resource csResource) {
        TreeIterator tit = csResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Pivotable)) continue;
            Element pObject = ((Pivotable)eObject).getPivot();
            if (pObject instanceof Package) {
                this.gatherNewPackage(newPackages, (EObject)pObject);
            } else {
                if (pObject instanceof Type) {
                    this.gatherNewPackage(newPackages, (EObject)pObject);
                } else if (pObject instanceof Operation) {
                    this.gatherNewPackage(newPackages, (EObject)pObject);
                } else if (pObject instanceof Property) {
                    this.gatherNewPackage(newPackages, (EObject)pObject);
                }
                tit.prune();
            }
            if (!(eObject instanceof MorePivotable)) continue;
            for (Element pivot : ((MorePivotable)eObject).getMorePivots()) {
                this.gatherNewPackage(newPackages, (EObject)pivot);
            }
        }
    }

    protected void gatherOldPackages(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            String qualifiedName;
            Package oldPkg;
            if (!(eObject instanceof Package)) continue;
            Package pkg = (Package)eObject;
            String name = pkg.getName();
            if (name == null) {
                name = "$null$";
            }
            if ((oldPkg = this.oldPackagesByQualifiedName.put(qualifiedName = this.getQualifiedName(new StringBuilder(), pkg), pkg)) != null) {
                logger.warn((Object)("Duplicate qualified package name: " + qualifiedName));
            }
            if (name.equals(qualifiedName)) {
                oldPkg = this.oldPackagesByName.put(name, pkg);
                if (oldPkg != null && name.equals(this.getQualifiedName(new StringBuilder(), oldPkg))) {
                    logger.warn((Object)("Duplicate unqualified package name: " + qualifiedName));
                }
            } else {
                oldPkg = this.oldPackagesByName.get(name);
                if (oldPkg == null) {
                    this.oldPackagesByName.put(name, pkg);
                }
            }
            this.gatherOldPackages((List<? extends EObject>)pkg.getNestedPackage());
        }
    }

    public final CS2Pivot getConverter() {
        return this.converter;
    }

    public <T> T getIntermediate(CacheKey<T> key) {
        return (T)this.intermediateCache.get(key);
    }

    public final MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public Package getOldPackageByQualifiedName(PackageCS csElement) {
        String qualifiedName = this.getQualifiedName(new StringBuilder(), csElement);
        return this.oldPackagesByQualifiedName.get(qualifiedName);
    }

    public Package getOldPackageBySimpleName(String name) {
        return this.oldPackagesByName.get(name);
    }

    protected String getQualifiedName(StringBuilder s, Package pkg) {
        String name;
        Package nestingPackage = pkg.getNestingPackage();
        if (nestingPackage != null) {
            this.getQualifiedName(s, nestingPackage);
            s.append("$$");
        }
        if ((name = pkg.getName()) == null) {
            name = "$null$";
        }
        s.append(name);
        return s.toString();
    }

    protected String getQualifiedName(StringBuilder s, PackageCS csPackage) {
        String name;
        EObject eContainer = csPackage.eContainer();
        if (eContainer instanceof PackageCS) {
            this.getQualifiedName(s, (PackageCS)eContainer);
            s.append("$$");
        }
        if ((name = csPackage.getName()) == null) {
            URI csURI;
            Resource csResource;
            name = "$null$";
            if (eContainer == null && (csResource = csPackage.eResource()) != null && (csURI = csResource.getURI()) != null) {
                name = csURI.lastSegment();
            }
        }
        s.append(name);
        return s.toString();
    }

    protected List<TemplateBindingCS> getTemplateBindings(ElementCS csElement) {
        TypedTypeRefCS csTemplateableElement;
        TemplateBindingCS csTemplateBinding;
        ArrayList<TemplateBindingCS> csTemplateBindings = new ArrayList<TemplateBindingCS>();
        if (csElement instanceof TypedTypeRefCS && (csTemplateBinding = (csTemplateableElement = (TypedTypeRefCS)csElement).getOwnedTemplateBinding()) != null) {
            csTemplateBindings.add(csTemplateBinding);
        }
        return csTemplateBindings;
    }

    protected List<TemplateSignature> getTemplateSignatures(Element pivotElement) {
        TemplateableElement templateableElement;
        TemplateSignature templateSignature;
        EObject container = pivotElement.eContainer();
        List<Object> pivotTemplateSignatures = container instanceof Element ? this.getTemplateSignatures((Element)container) : new ArrayList();
        if (pivotElement instanceof TemplateableElement && (templateSignature = (templateableElement = (TemplateableElement)pivotElement).getOwnedTemplateSignature()) != null) {
            pivotTemplateSignatures.add(templateSignature);
        }
        return pivotTemplateSignatures;
    }

    public InterDependency<BasePreOrderVisitor.TemplateSignatureContinuation> getTypesHaveSignaturesInterDependency() {
        return this.typesHaveSignatures;
    }

    public void handleVisitNamedElement(NamedElementCS csNamedElement, NamedElement pivotElement) {
        EList pivotAnnotations = pivotElement.getOwnedAnnotation();
        EList<AnnotationElementCS> csAnnotations = csNamedElement.getOwnedAnnotation();
        this.refreshPivotList((Class)Annotation.class, (List)pivotAnnotations, (List<? extends ModelElementCS>)csAnnotations);
    }

    public void installPivotReference(ElementRefCS csElement, Element newPivotElement, EReference eReference) {
        this.converter.installPivotReference(csElement, newPivotElement, eReference);
    }

    public void installPivotUsage(ModelElementCS csElement, Element newPivotElement) {
        this.converter.installPivotUsage(csElement, newPivotElement);
    }

    protected void installRootContents(Resource csResource) {
        for (EObject eObject : csResource.getContents()) {
            Resource pivotResource;
            Element pivotElement;
            if (!(eObject instanceof Pivotable) || (pivotElement = ((Pivotable)eObject).getPivot()) == null || (pivotResource = pivotElement.eResource()) != null || (pivotResource = this.converter.getPivotResource(csResource)) == null) continue;
            pivotResource.getContents().add((Object)pivotElement);
        }
    }

    protected List<BasicContinuation<?>> progressContinuations(List<BasicContinuation<?>> continuations) {
        ArrayList moreContinuations = new ArrayList();
        boolean madeProgress = false;
        boolean tracingOn = CONTINUATION.isActive();
        if (tracingOn) {
            CONTINUATION.println("------------------------------------------------ " + continuations.size());
            CONTINUATION.println(this.typesHaveSignatures.toString());
        }
        for (BasicContinuation<?> continuation : continuations) {
            boolean canExecute = continuation.canExecute();
            if (tracingOn) {
                CONTINUATION.println(String.valueOf(canExecute ? "+ " : "- ") + continuation);
            }
            if (canExecute) {
                madeProgress = true;
                BasicContinuation<?> nextContinuation = continuation.execute();
                if (nextContinuation == null) continue;
                nextContinuation.addTo(moreContinuations);
                continue;
            }
            moreContinuations.add(continuation);
        }
        return madeProgress ? moreContinuations : null;
    }

    public <T> T putIntermediate(CacheKey<T> key, T object) {
        return (T)this.intermediateCache.put(key, object);
    }

    public void refreshComments(Element pivotElement, ElementCS csElement) {
        List<ILeafNode> documentationNodes;
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        if (node != null && (documentationNodes = CS2Pivot.getDocumentationNodes(node)) != null) {
            Comment comment;
            ArrayList<String> documentationStrings = new ArrayList<String>();
            for (ILeafNode documentationNode : documentationNodes) {
                String text = documentationNode.getText();
                int startIndex = text.startsWith("/**") ? 3 : 0;
                int endIndex = text.length() - (text.endsWith("*/") ? (text.endsWith("**/") ? 3 : 2) : 0);
                if (startIndex >= endIndex) continue;
                documentationStrings.add(text.substring(startIndex, endIndex).trim());
            }
            EList ownedComments = pivotElement.getOwnedComment();
            int iMax = Math.min(documentationStrings.size(), ownedComments.size());
            int i = 0;
            while (i < iMax) {
                String string = (String)documentationStrings.get(i);
                String trimmedString = this.trimComments(string);
                if (!trimmedString.equals((comment = (Comment)ownedComments.get(i)).getBody())) {
                    comment.setBody(trimmedString);
                }
                ++i;
            }
            while (i < documentationStrings.size()) {
                String string = (String)documentationStrings.get(i);
                String trimmedString = this.trimComments(string);
                comment = PivotFactory.eINSTANCE.createComment();
                comment.setBody(trimmedString);
                ownedComments.add(comment);
                ++i;
            }
            while (i < ownedComments.size()) {
                ownedComments.remove(ownedComments.size() - 1);
            }
        }
    }

    public <T extends Element> void refreshList(Class<T> pivotClass, List<T> pivotElements, List<? extends PivotableElementCS> csElements) {
        if (!pivotElements.isEmpty() || !csElements.isEmpty()) {
            ArrayList<Element> newPivotElements = new ArrayList<Element>();
            for (PivotableElementCS pivotableElementCS : csElements) {
                Object pivotElement = PivotUtil.getPivot(pivotClass, (Pivotable)pivotableElementCS);
                if (pivotElement == null && pivotableElementCS instanceof ModelElementCS) {
                    pivotElement = this.converter.getPivotElement(pivotClass, (ModelElementCS)pivotableElementCS);
                }
                if (pivotElement == null || newPivotElements.contains(pivotElement)) continue;
                newPivotElements.add((Element)pivotElement);
            }
            PivotUtil.refreshList(pivotElements, newPivotElements);
        }
    }

    public <T extends Element> T refreshModelElement(Class<T> pivotClass, EClass pivotEClass, ModelElementCS csElement) {
        return this.converter.refreshModelElement(pivotClass, pivotEClass, csElement);
    }

    public <T extends Element> void refreshPivotList(Class<T> pivotClass, List<? super T> pivotElements, List<? extends ModelElementCS> csElements) {
        if (pivotElements.isEmpty() && csElements.isEmpty()) {
            return;
        }
        ArrayList<Element> newPivotElements = new ArrayList<Element>();
        for (ModelElementCS modelElementCS : csElements) {
            Element pivotElement = PivotUtil.getPivot(pivotClass, (Pivotable)modelElementCS);
            if (pivotElement != null) {
                newPivotElements.add(pivotElement);
                continue;
            }
            assert (pivotElement != null);
        }
        PivotUtil.refreshList(pivotElements, newPivotElements);
    }

    public void refreshTemplateSignature(TemplateableElementCS csTemplateableElement, TemplateableElement pivotTemplateableElement) {
        TemplateSignatureCS csTemplateSignature = csTemplateableElement.getOwnedTemplateSignature();
        if (csTemplateSignature == null) {
            if (pivotTemplateableElement.getOwnedTemplateSignature() != null) {
                pivotTemplateableElement.setOwnedTemplateSignature(null);
            }
            return;
        }
        TemplateSignature pivotTemplateSignature = (TemplateSignature)PivotUtil.getPivot(TemplateSignature.class, (Pivotable)csTemplateSignature);
        if (pivotTemplateableElement.getOwnedTemplateSignature() != pivotTemplateSignature) {
            pivotTemplateableElement.setOwnedTemplateSignature(pivotTemplateSignature);
        }
    }

    protected void resetPivotMappings(Collection<? extends Resource> csResources) {
        for (Resource resource : csResources) {
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Pivotable)) continue;
                Pivotable pivotable = (Pivotable)eObject;
                pivotable.resetPivot();
            }
        }
    }

    public void setReferredIteration(LoopExp expression, Iteration iteration) {
        expression.setReferredIteration(iteration);
    }

    public void setReferredOperation(OperationCallExp expression, Operation operation) {
        expression.setReferredOperation(operation);
    }

    protected void specializeTemplateBindings(List<TemplateBinding> templateBindings, List<TemplateSignature> templateSignatures, List<TemplateBindingCS> csTemplateBindings) {
        int pivotIMax;
        int csIMax = csTemplateBindings.size();
        if (csIMax != (pivotIMax = templateSignatures.size())) {
            logger.warn((Object)("Inconsistent template bindings size for " + CS2Moniker.toString(csTemplateBindings.get(0).getOwningTemplateBindableElement())));
        }
        int newMax = Math.min(csIMax, pivotIMax);
        int i = 0;
        while (i < newMax) {
            TemplateBindingCS csTemplateBinding = csTemplateBindings.get(i);
            TemplateSignature templateSignature = templateSignatures.get(i);
            int oldMax = templateBindings.size();
            TemplateBinding templateBinding = null;
            int j = i;
            while (j < oldMax) {
                TemplateBinding oldTemplateBinding = templateBindings.get(j);
                if (oldTemplateBinding.getSignature() == templateSignature) {
                    if (j != i) {
                        templateBindings.add(i, templateBindings.remove(j));
                    }
                    templateBinding = oldTemplateBinding;
                    break;
                }
                ++j;
            }
            if (templateBinding == null) {
                templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
                templateBinding.setSignature(templateSignature);
                if (i < oldMax) {
                    templateBindings.add(i, templateBinding);
                } else {
                    templateBindings.add(templateBinding);
                }
            }
            this.installPivotReference(csTemplateBinding, (Element)templateBinding, BaseCSTPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
            this.specializeTemplateParameterSubstitutions((List<TemplateParameterSubstitution>)templateBinding.getParameterSubstitution(), (List<TemplateParameter>)templateSignature.getOwnedParameter(), (List<TemplateParameterSubstitutionCS>)csTemplateBinding.getOwnedParameterSubstitution());
            assert (templateSignatures.get(i) == templateBindings.get(i).getSignature());
            ++i;
        }
        int k = templateBindings.size();
        while (k > newMax) {
            templateBindings.remove(--k);
        }
        assert (templateSignatures.size() == templateBindings.size());
    }

    protected void specializeTemplateParameterSubstitutions(List<TemplateParameterSubstitution> templateParameterSubstitutions, List<TemplateParameter> templateParameters, List<TemplateParameterSubstitutionCS> csTemplateParameterSubstitutions) {
        int pivotIMax;
        int csIMax = csTemplateParameterSubstitutions.size();
        if (csIMax != (pivotIMax = templateParameters.size())) {
            logger.warn((Object)"Inconsistent template parameter substitutions size");
        }
        int newMax = Math.min(csIMax, pivotIMax);
        int i = 0;
        while (i < newMax) {
            ParameterableElement pivotActualParameter;
            TypeRefCS csActualParameter;
            TemplateParameterSubstitutionCS csTemplateParameterSubstitution = csTemplateParameterSubstitutions.get(i);
            TemplateParameter templateParameter = templateParameters.get(i);
            int oldMax = templateParameterSubstitutions.size();
            TemplateParameterSubstitution templateParameterSubstitution = null;
            int j = i;
            while (j < oldMax) {
                TemplateParameterSubstitution oldTemplateParameterSubstitution = templateParameterSubstitutions.get(j);
                if (oldTemplateParameterSubstitution.getFormal() == templateParameter) {
                    if (j != i) {
                        templateParameterSubstitutions.add(i, templateParameterSubstitutions.remove(j));
                    }
                    templateParameterSubstitution = oldTemplateParameterSubstitution;
                    break;
                }
                ++j;
            }
            if (templateParameterSubstitution == null) {
                templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
                templateParameterSubstitution.setFormal(templateParameter);
                if (i < oldMax) {
                    templateParameterSubstitutions.add(i, templateParameterSubstitution);
                } else {
                    templateParameterSubstitutions.add(templateParameterSubstitution);
                }
            }
            if ((csActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter()) instanceof WildcardTypeRefCS) {
                pivotActualParameter = templateParameterSubstitution.getOwnedActual();
                if (pivotActualParameter == null) {
                    pivotActualParameter = PivotFactory.eINSTANCE.createClass();
                    templateParameterSubstitution.setOwnedActual(pivotActualParameter);
                }
                String name = "wildcard";
                if (i > 1) {
                    name = String.valueOf(name) + i;
                }
                ((NamedElement)pivotActualParameter).setName(name);
            } else {
                pivotActualParameter = (ParameterableElement)PivotUtil.getPivot(ParameterableElement.class, (Pivotable)csActualParameter);
                templateParameterSubstitution.setActual(pivotActualParameter);
            }
            assert (templateParameters.get(i) == templateParameterSubstitutions.get(i).getFormal());
            ++i;
        }
        int k = templateParameterSubstitutions.size();
        while (k > newMax) {
            templateParameterSubstitutions.remove(--k);
        }
        assert (templateParameters.size() == templateParameterSubstitutions.size());
    }

    protected TemplateableElement specializeTemplates(TypedTypeRefCS csElement) {
        TemplateBindingCS ownedTemplateBinding = csElement.getOwnedTemplateBinding();
        assert (ownedTemplateBinding != null);
        Type unspecializedPivotElement = csElement.getType();
        if (unspecializedPivotElement == null || unspecializedPivotElement.eIsProxy()) {
            String moniker = CS2Moniker.toString(csElement);
            logger.error((Object)("Nothing to specialize as " + moniker));
            return null;
        }
        Type specializedPivotElement = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csElement);
        if (specializedPivotElement == null) {
            ArrayList<Type> templateArguments = new ArrayList<Type>();
            for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : ownedTemplateBinding.getOwnedParameterSubstitution()) {
                Type templateArgument = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTemplateParameterSubstitution.getOwnedActualParameter());
                templateArguments.add(templateArgument);
            }
            specializedPivotElement = this.metaModelManager.getLibraryType(unspecializedPivotElement, templateArguments);
        }
        this.installPivotReference(csElement, (Element)specializedPivotElement, BaseCSTPackage.Literals.TYPED_TYPE_REF_CS__TYPE);
        if (specializedPivotElement != unspecializedPivotElement) {
            EList templateBindings = specializedPivotElement.getTemplateBinding();
            List<TemplateSignature> templateSignatures = this.getTemplateSignatures((Element)unspecializedPivotElement);
            List<TemplateBindingCS> csTemplateBindings = this.getTemplateBindings(csElement);
            this.specializeTemplateBindings((List<TemplateBinding>)templateBindings, templateSignatures, csTemplateBindings);
        }
        return specializedPivotElement;
    }

    protected String trimComments(String string) {
        String line;
        String[] strings = string.trim().split("\n");
        boolean isFormatted = true;
        int i = 0;
        while (i < strings.length) {
            line = strings[i];
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("*")) {
                if (trimmedLine.length() > 1 && !Character.isWhitespace(trimmedLine.charAt(1))) {
                    isFormatted = false;
                    break;
                }
            } else if (i > 0) {
                isFormatted = false;
                break;
            }
            ++i;
        }
        StringBuilder s = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            String trimmedLine = line.trim();
            if (isFormatted) {
                if (trimmedLine.length() <= 1) {
                    trimmedLine = "";
                } else if (Character.isWhitespace(trimmedLine.charAt(1))) {
                    trimmedLine = trimmedLine.substring(2);
                }
            }
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(trimmedLine);
            ++n2;
        }
        String trimmedString = s.toString();
        return trimmedString;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean update() {
        this.resetPivotMappings(this.csResources);
        this.oldPackagesByName = new HashMap<String, Package>();
        this.oldPackagesByQualifiedName = new HashMap<String, Package>();
        for (Resource resource : this.converter.cs2pivotResourceMap.values()) {
            this.gatherOldPackages((List<? extends EObject>)resource.getContents());
        }
        continuations = new ArrayList<BasicContinuation<?>>();
        for (Resource csResource : this.csResources) {
            for (Object eObject : csResource.getContents()) {
                this.visitContainment((EObject)eObject, continuations);
            }
        }
        while (continuations.size() > 0) {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                hasNoErrors = this.checkForNoErrors(this.csResources);
                if (!hasNoErrors) {
                    return false;
                }
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
        }
        for (Resource csResource : this.csResources) {
            this.installRootContents(csResource);
        }
        for (Resource csResource : this.csResources) {
            for (Object eObject : csResource.getContents()) {
                this.visitInPreOrder((EObject)eObject, continuations);
            }
        }
        while (continuations.size() > 0) {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                hasNoErrors = this.checkForNoErrors(this.csResources);
                if (!hasNoErrors) {
                    return false;
                }
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
        }
        if (this.metaModelManager.getLibraryResource() == null && this.metaModelManager.getDefaultStandardLibraryURI() == null) {
            for (Resource resource : this.converter.cs2pivotResourceMap.values()) {
                this.metaModelManager.loadLibrary(resource);
            }
        }
        if ((oclAnyType = this.metaModelManager.getOclAnyType()) == null) {
            return false;
        }
        for (Resource csResource : this.csResources) {
            for (EObject eObject : csResource.getContents()) {
                this.visitInPostOrder(eObject, continuations);
            }
        }
        hasNoErrors = this.checkForNoErrors(this.csResources);
        if (hasNoErrors) ** GOTO lbl60
        return false;
lbl-1000:
        // 1 sources

        {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
lbl60:
            // 2 sources

            ** while (continuations.size() > 0)
        }
lbl61:
        // 3 sources

        for (Resource csResource : this.csResources) {
            this.installRootContents(csResource);
        }
        this.resolveUnderspecifiedTypes();
        hasNoMoreErrors = this.checkForNoErrors(this.csResources);
        if (!hasNoMoreErrors) {
            return false;
        }
        newPackages = new HashSet<Package>();
        for (Resource csResource : this.csResources) {
            this.gatherNewPackages(newPackages, csResource);
        }
        obsoletePackages = new HashSet<Package>(this.oldPackagesByQualifiedName.values());
        obsoletePackages.removeAll(newPackages);
        for (Package obsoletePackage : obsoletePackages) {
            eContainer = obsoletePackage.eContainer();
            if (eContainer == null) continue;
            eContainmentFeature = obsoletePackage.eContainmentFeature();
            if (eContainmentFeature.isMany()) {
                siblings = (List)eContainer.eGet((EStructuralFeature)eContainmentFeature);
                siblings.remove(obsoletePackage);
                continue;
            }
            eContainer.eSet((EStructuralFeature)eContainmentFeature, null);
        }
        return true;
    }

    protected void visitContainment(EObject eObject, List<BasicContinuation<?>> continuations) {
        for (EObject eContent : eObject.eContents()) {
            this.visitContainment(eContent, continuations);
        }
        Continuation<?> continuation = ((VisitableCS)eObject).accept(this.containmentVisitor);
        if (continuation != null) {
            continuation.addTo(continuations);
        }
    }

    public <T extends Element> T visitLeft2Right(Class<T> pivotClass, VisitableCS csObject) {
        if (csObject == null) {
            return null;
        }
        Element element = csObject.accept(this.left2RightVisitor);
        if (element == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    protected void visitInPostOrder(EObject eObject, List<BasicContinuation<?>> continuations) {
        for (EObject eContent : eObject.eContents()) {
            this.visitInPostOrder(eContent, continuations);
        }
        Continuation<?> continuation = ((VisitableCS)eObject).accept(this.postOrderVisitor);
        if (continuation != null) {
            continuation.addTo(continuations);
        }
    }

    protected void visitInPreOrder(EObject eObject, List<BasicContinuation<?>> continuations) {
        Continuation<?> continuation = ((VisitableCS)eObject).accept(this.preOrderVisitor);
        if (continuation != null) {
            continuation.addTo(continuations);
        }
        for (EObject eContent : eObject.eContents()) {
            this.visitInPreOrder(eContent, continuations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheKey<T> {
        protected final String name;

        public CacheKey(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

