/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.AbstractDependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterDependency<T>
extends AbstractDependency<Object> {
    private Dependency dependency;
    private List<T> dependencies = new ArrayList<T>();
    private List<T> satisfied = new ArrayList<T>();

    public InterDependency(String reason, Dependency dependency) {
        super(reason);
        this.dependency = dependency;
    }

    public void addDependency(T dependency) {
        assert (this.satisfied.isEmpty());
        assert (!this.dependencies.contains(dependency));
        this.dependencies.add(dependency);
    }

    @Override
    public boolean canExecute() {
        if (this.dependency != null && !this.dependency.canExecute()) {
            return false;
        }
        return this.satisfied.size() >= this.dependencies.size();
    }

    public void setSatisfied(T dependency) {
        assert (this.dependencies.contains(dependency));
        assert (!this.satisfied.contains(dependency));
        this.satisfied.add(dependency);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(super.toString());
        if (this.dependency != null && !this.dependency.canExecute()) {
            s.append(" BLOCKED");
        }
        s.append(" ");
        s.append(this.satisfied.size());
        s.append("/");
        s.append(this.dependencies.size());
        return s.toString();
    }
}

