/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scoping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.ocl.examples.xtext.base.scoping.IScopeView;
import org.eclipse.ocl.examples.xtext.base.scoping.QualifiedPath;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseScopeView
extends AbstractScope
implements IScopeView {
    private static final Logger logger = Logger.getLogger(BaseScopeView.class);
    public static final IScopeView NULLSCOPEVIEW = new IScopeView(){

        public Iterable<IEObjectDescription> getAllElements() {
            return Collections.emptyList();
        }

        public Attribution getAttribution() {
            return null;
        }

        public EObject getChild() {
            return null;
        }

        public EStructuralFeature getContainmentFeature() {
            return null;
        }

        public Iterable<IEObjectDescription> getElements(EObject object) {
            return Collections.emptyList();
        }

        public Iterable<IEObjectDescription> getElements(QualifiedName name) {
            return Collections.emptyList();
        }

        @Override
        public IScopeView getParent() {
            return NULLSCOPEVIEW;
        }

        public IEObjectDescription getSingleElement(QualifiedName name) {
            return null;
        }

        public IEObjectDescription getSingleElement(EObject object) {
            return null;
        }

        public EObject getTarget() {
            return null;
        }

        public EReference getTargetReference() {
            return null;
        }
    };
    protected final MetaModelManager metaModelManager;
    protected final Attribution attribution;
    protected final EObject target;
    protected final EObject child;
    protected final EStructuralFeature containmentFeature;
    protected final EReference targetReference;

    public static void computeLookups(EnvironmentView environmentView, ElementCS parent, EObject child, EStructuralFeature containmentFeature, EReference targetReference) {
        MetaModelManager metaModelManager = environmentView.getMetaModelManager();
        Attribution attribution = parent != null ? PivotUtil.getAttribution((EObject)parent) : null;
        BaseScopeView baseScopeView = new BaseScopeView(metaModelManager, parent, attribution, child, containmentFeature, targetReference);
        environmentView.computeLookups((ScopeView)baseScopeView);
    }

    private static IScopeView getParent(MetaModelManager metaModelManager, EObject target, EReference targetReference) {
        Element pParent;
        ElementCS parent = null;
        Attribution parentScope = null;
        if (target instanceof ElementCS) {
            ElementCS csParent = ((ElementCS)target).getLogicalParent();
            if (csParent != null) {
                parentScope = PivotUtil.getAttribution((EObject)csParent);
                parent = csParent;
            }
        } else if (target instanceof Element && (pParent = (Element)((Element)target).eContainer()) != null) {
            parentScope = PivotUtil.getAttribution((EObject)pParent);
            parent = pParent;
        }
        if (parentScope == null) {
            return NULLSCOPEVIEW;
        }
        EStructuralFeature eContainingFeature = target.eContainingFeature();
        return new BaseScopeView(metaModelManager, parent, parentScope, target, eContainingFeature, targetReference);
    }

    public BaseScopeView(MetaModelManager metaModelManager, EObject target, Attribution attribution, EObject child, EStructuralFeature containmentFeature, EReference targetReference) {
        super((IScope)BaseScopeView.getParent(metaModelManager, target, targetReference), false);
        this.metaModelManager = metaModelManager;
        this.attribution = attribution;
        this.target = target;
        this.child = child;
        this.containmentFeature = containmentFeature;
        this.targetReference = targetReference;
    }

    public Iterable<IEObjectDescription> getAllElements() {
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)this.targetReference, null);
        try {
            ScopeView aScope = this.attribution.computeLookup(this.target, environmentView, (ScopeView)this);
            if (aScope != null) {
                environmentView.computeLookups(aScope);
            }
        }
        catch (IllegalLibraryException illegalLibraryException) {
            // empty catch block
        }
        return this.getDescriptions(environmentView);
    }

    protected final Iterable<IEObjectDescription> getAllLocalElements() {
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)this.targetReference, null);
        this.attribution.computeLookup(this.target, environmentView, (ScopeView)this);
        return this.getDescriptions(environmentView);
    }

    public Attribution getAttribution() {
        return this.attribution;
    }

    public EObject getChild() {
        return this.child;
    }

    public EStructuralFeature getContainmentFeature() {
        return this.containmentFeature;
    }

    private IEObjectDescription getDescription(EnvironmentView environmentView) {
        int contentsSize = environmentView.getSize();
        if (contentsSize == 0) {
            return null;
        }
        if (contentsSize != 1) {
            logger.warn((Object)("Unhandled ambiguous content for '" + environmentView.getName() + "'"));
        }
        for (Map.Entry entry : environmentView.getEntries()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                value = values.get(values.size() - 1);
            }
            if (!(value instanceof EObject)) continue;
            return EObjectDescription.create((String)((String)entry.getKey()), (EObject)((EObject)value));
        }
        return null;
    }

    private List<IEObjectDescription> getDescriptions(EnvironmentView environmentView) {
        ArrayList<IEObjectDescription> contents = new ArrayList<IEObjectDescription>();
        for (Map.Entry entry : environmentView.getEntries()) {
            Object values = entry.getValue();
            if (values instanceof EObject) {
                contents.add(EObjectDescription.create((String)((String)entry.getKey()), (EObject)((EObject)values)));
                continue;
            }
            if (!(values instanceof List)) continue;
            for (Object value : (List)values) {
                contents.add(EObjectDescription.create((String)((String)entry.getKey()), (EObject)((EObject)value)));
            }
        }
        return contents;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)this.targetReference, name.toString());
        int size = environmentView.computeLookups((ScopeView)this);
        if (size <= 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(this.getDescription(environmentView));
        }
        List<IEObjectDescription> contents = this.getDescriptions(environmentView);
        return contents;
    }

    /*
     * Unable to fully structure code
     */
    public Iterable<IEObjectDescription> getElements(EObject object) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        descriptiveName = null;
                        if (this.targetReference != BaseCSTPackage.Literals.IMPORT_CS__NAMESPACE) break block8;
                        descriptiveName = this.getNonPivotURI(object);
                        break block9;
                    }
                    if (this.targetReference != BaseCSTPackage.Literals.MODEL_ELEMENT_REF_CS__ELEMENT) break block10;
                    descriptiveName = this.getNonPivotURI(object);
                    break block9;
                }
                if (this.targetReference != BaseCSTPackage.Literals.REFERENCE_CS__OPPOSITE) break block11;
                descriptiveName = ((NamedElement)object).getName();
                break block9;
            }
            if (this.targetReference != BaseCSTPackage.Literals.TYPED_TYPE_REF_CS__TYPE || !(object instanceof Type)) ** GOTO lbl35
            if (object instanceof PrimitiveType) {
                descriptiveName = ((PrimitiveType)object).getName();
            } else {
                csRef = this.getTarget();
                while (csRef.eContainer() instanceof TypeRefCS || csRef.eContainer() instanceof TemplateParameterSubstitutionCS || csRef.eContainer() instanceof TemplateBindingCS) {
                    csRef = csRef.eContainer();
                }
                csContext = (ModelElementCS)csRef.eContainer();
                aliasAnalysis = AliasAnalysis.getAdapter(EcoreUtil.getRootContainer((EObject)csContext).eResource());
                context = csContext.getPivot();
                while (context != null && !(context instanceof Namespace) && !(context instanceof Type)) {
                    container = context.eContainer();
                    if (!(container instanceof Element)) break;
                    context = (Element)container;
                }
                contextPath = new QualifiedPath(aliasAnalysis.getPath(context));
                objectPath = new QualifiedPath(aliasAnalysis.getPath((Element)object));
                qualifiedRelativeName = objectPath.deresolve(contextPath);
                objectDescription = EObjectDescription.create((QualifiedName)qualifiedRelativeName, (EObject)object);
                return Collections.singletonList(objectDescription);
lbl35:
                // 1 sources

                if (object instanceof NamedElement) {
                    csRef = this.getTarget();
                    while (csRef.eContainer() instanceof TypeRefCS || csRef.eContainer() instanceof TemplateParameterSubstitutionCS || csRef.eContainer() instanceof TemplateBindingCS) {
                        csRef = csRef.eContainer();
                    }
                    csContext = (Pivotable)csRef.eContainer();
                    aliasAnalysis = AliasAnalysis.getAdapter(csContext.eResource());
                    context = csContext.getPivot();
                    while (context != null && !(context instanceof Namespace) && !(context instanceof Type)) {
                        container = context.eContainer();
                        if (!(container instanceof Element)) break;
                        context = (Element)container;
                    }
                    contextPath = new QualifiedPath(aliasAnalysis.getPath(context));
                    objectPath = new QualifiedPath(aliasAnalysis.getPath((Element)object));
                    qualifiedRelativeName = objectPath.deresolve(contextPath);
                    objectDescription = EObjectDescription.create((QualifiedName)qualifiedRelativeName, (EObject)object);
                    return Collections.singletonList(objectDescription);
                }
            }
        }
        if (descriptiveName != null) {
            objectDescription = EObjectDescription.create((String)descriptiveName, (EObject)object);
            return Collections.singletonList(objectDescription);
        }
        return super.getElements(object);
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    private String getNonPivotURI(EObject object) {
        EObject target;
        URI uri = null;
        if (object instanceof PivotObjectImpl && (target = ((PivotObjectImpl)object).getTarget()) != null) {
            uri = EcoreUtil.getURI((EObject)target);
        }
        if (uri == null) {
            uri = EcoreUtil.getURI((EObject)object);
        }
        if (uri == null) {
            return null;
        }
        if (PivotUtil.isPivotURI((URI)uri)) {
            uri = PivotUtil.getNonPivotURI((URI)uri);
        }
        return uri.toString();
    }

    @Override
    public IScopeView getParent() {
        return (IScopeView)super.getParent();
    }

    public IEObjectDescription getSingleElement(EObject object) {
        if (object instanceof NamedElement) {
            return EObjectDescription.create((String)((NamedElement)object).getName(), (EObject)object);
        }
        return super.getSingleElement(object);
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)this.targetReference, name.toString());
        int size = environmentView.computeLookups((ScopeView)this);
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return this.getDescription(environmentView);
        }
        return null;
    }

    public final EObject getTarget() {
        return this.target;
    }

    public EReference getTargetReference() {
        return this.targetReference;
    }

    public String toString() {
        EObject target = this.getTarget();
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(target.eClass().getName());
        if (this.containmentFeature != null) {
            s.append("::");
            s.append(this.containmentFeature.getName());
        }
        s.append("] ");
        s.append(String.valueOf(target));
        return s.toString();
    }
}

