/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.List;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.LibraryDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.BasePlugin;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.linking.lazy.LazyLinker;

public class CS2PivotLinker
extends LazyLinker {
    protected void afterModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        Resource eResource = model.eResource();
        if (eResource instanceof BaseCSResource && !ElementUtil.hasSyntaxError((List<Resource.Diagnostic>)eResource.getErrors())) {
            BaseCSResource csResource = (BaseCSResource)eResource;
            try {
                CS2PivotResourceAdapter resourceAdapter = CS2PivotResourceAdapter.getAdapter(csResource, null);
                resourceAdapter.refreshPivotMappings(diagnosticsConsumer);
            }
            catch (Exception exception) {
                Exception cause;
                Exception exception2 = cause = exception instanceof Resource.IOWrappedException ? (Exception)exception.getCause() : exception;
                if (cause instanceof IllegalLibraryException) {
                    eResource.getErrors().add((Object)new LibraryDiagnostic(cause));
                }
                eResource.getErrors().add((Object)new ExceptionDiagnostic(cause));
                BasePlugin.error(0, String.valueOf(csResource.getEditorName()) + " Editor linking error", cause);
            }
        }
    }

    public static class DiagnosticWrappedException
    extends WrappedException
    implements Resource.Diagnostic {
        private static final long serialVersionUID = 1L;

        public DiagnosticWrappedException(Exception exception) {
            super(exception);
        }

        public String getLocation() {
            return "unknown";
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }
    }
}

