/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.serializer;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.essentialocl.services.EssentialOCLGrammarAccess;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.serializer.sequencer.HiddenTokenSequencer;

public class EssentialOCLHiddenTokenSequencer
extends HiddenTokenSequencer {
    @Inject
    private EssentialOCLGrammarAccess grammarAccess;

    protected void emitComments(EObject semanticChild) {
        Element pivot;
        if (semanticChild instanceof ModelElementCS && (pivot = ((ModelElementCS)semanticChild).getPivot()) != null) {
            String commentIndent = this.getCommentIndent(semanticChild);
            for (Comment comment : pivot.getOwnedComment()) {
                String body = "\n" + commentIndent + "/**\n" + commentIndent + " * " + comment.getBody().replaceAll("\\n", "\n" + commentIndent + " * ") + "\n" + commentIndent + " */\n";
                this.delegate.acceptComment((AbstractRule)this.grammarAccess.getML_COMMENTRule(), body, null);
            }
        }
    }

    public boolean enterAssignedAction(Action action, EObject semanticChild, ICompositeNode node) {
        this.emitComments(semanticChild);
        return super.enterAssignedAction(action, semanticChild, node);
    }

    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject semanticChild, ICompositeNode node) {
        if (!super.enterAssignedParserRuleCall(rc, semanticChild, node)) {
            return false;
        }
        this.emitComments(semanticChild);
        return true;
    }

    protected String getCommentIndent(EObject semanticChild) {
        return "\t\t\t\t";
    }
}

