/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.palette.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.papyrus.customization.palette.dialog.PaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.service.AspectCreationEntry;
import org.eclipse.papyrus.uml.diagram.common.service.palette.AspectToolService;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteAspectToolEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPreAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.StereotypePostAction;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteAspectToolEntryProxy
extends PaletteEntryProxy
implements IPaletteAspectToolEntryProxy {
    protected List<IPostAction> postActions = new ArrayList<IPostAction>();
    protected List<IPreAction> preActions = new ArrayList<IPreAction>();

    public PaletteAspectToolEntryProxy(AspectCreationEntry entry) {
        super((PaletteEntry)entry);
        this.initAspectActions();
    }

    public List<IPostAction> getPostActions() {
        return this.postActions;
    }

    public void setPostActions(List<IPostAction> postActions) {
        this.postActions = postActions;
    }

    protected List<IPreAction> getPreActions() {
        return this.preActions;
    }

    protected void setPreActions(List<IPreAction> preActions) {
        this.preActions = preActions;
    }

    public List<IAspectAction> getAspectActions() {
        ArrayList<IAspectAction> actions = new ArrayList<IAspectAction>();
        actions.addAll(this.preActions);
        actions.addAll(this.postActions);
        return actions;
    }

    protected void initAspectActions() {
        Object value = this.getEntry().getAspectProperties("aspectActions");
        if (value instanceof NodeList) {
            NodeList nodeList = (NodeList)value;
            int i = 0;
            while (i < nodeList.getLength()) {
                Node childNode = nodeList.item(i);
                String childName = childNode.getNodeName();
                if ("postAction".equals(childName)) {
                    IAspectActionProvider provider = AspectToolService.getInstance().getProvider(AspectToolService.getProviderId((Node)childNode));
                    if (provider != null) {
                        IPostAction action = (IPostAction)provider.createAction(childNode);
                        this.postActions.add(action);
                    } else {
                        Activator.log.error("impossible to find factory with id: " + AspectToolService.getProviderId((Node)childNode), null);
                    }
                } else {
                    "preAction".equals(childName);
                }
                ++i;
            }
        }
    }

    @Override
    public String getDescription() {
        return this.getEntry().getDescription();
    }

    @Override
    public String getImagePath() {
        String path = this.getEntry().getIconPath();
        return path != null ? path : "";
    }

    @Override
    public Image getImage() {
        if (this.getImagePath() != null && !this.getImagePath().equals("")) {
            return Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)this.getImagePath());
        }
        return super.getImage();
    }

    public AspectCreationEntry getEntry() {
        return (AspectCreationEntry)super.getEntry();
    }

    public String getReferencedPaletteID() {
        return this.getEntry().getReferencedEntry().getId();
    }

    public List<String> getStereotypesQNList() {
        ArrayList<String> list = new ArrayList<String>();
        for (IAspectAction iAspectAction : this.postActions) {
            if (!(iAspectAction instanceof StereotypePostAction)) continue;
            list.addAll(((StereotypePostAction)iAspectAction).getStereotypesToApply());
        }
        return list;
    }
}

