/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.generators;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQVTGenerator
implements IGenerator,
Listener {
    protected List<Context> generatedContexts;
    protected ModelExtent out;
    private Set<Listener> listeners = new HashSet<Listener>();

    @Override
    public List<Context> generate(URI targetURI) {
        URI transformationURI = this.getTransformationURI();
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        Diagnostic diagnostic = executor.loadTransformation();
        if (diagnostic.getSeverity() != 0) {
            Activator.log.warn("Cannot load the transformation : " + transformationURI);
            this.generatedContexts = null;
            return null;
        }
        List<ModelExtent> extents = this.getModelExtents();
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        context.setLog((Log)new WriterLog((Writer)new OutputStreamWriter(System.out)));
        ExecutionDiagnostic result = executor.execute((ExecutionContext)context, extents.toArray(new ModelExtent[0]));
        if (result.getSeverity() == 0) {
            List outObjects = this.getOutContextExtent().getContents();
            Object objectResult = outObjects.get(0);
            if (!(objectResult instanceof Context)) {
                return null;
            }
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource contextResource = resourceSet.createResource(targetURI);
            contextResource.getContents().addAll((Collection)outObjects);
            this.generatedContexts = this.getContexts(outObjects);
            return this.generatedContexts;
        }
        IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
        Activator.log.warn(String.format("%s : %s", status.getPlugin(), status.getMessage()));
        this.generatedContexts = null;
        return null;
    }

    protected abstract List<ModelExtent> getModelExtents();

    protected ModelExtent getOutContextExtent() {
        if (this.out == null) {
            this.out = new BasicModelExtent();
        }
        return this.out;
    }

    protected abstract URI getTransformationURI();

    protected EObject loadEMFModel(URI uri) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource != null && !resource.getContents().isEmpty()) {
                return (EObject)resource.getContents().get(0);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
        return null;
    }

    @Override
    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void handleEvent(Event event) {
        for (Listener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected List<Context> getContexts(List<EObject> outObjects) {
        LinkedList<Context> result = new LinkedList<Context>();
        for (EObject objectResult : outObjects) {
            if (!(objectResult instanceof Context)) continue;
            result.add((Context)objectResult);
        }
        return result;
    }
}

