/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.customization.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.widgets.Display;

public class RemoveContextAction {
    public void removeContext(final Context sourceContext) {
        final File directory = new File(sourceContext.eResource().getURI().toFileString()).getParentFile();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Deleting the property view configuration: " + sourceContext.getName(), -1);
                    ConfigurationManager.instance.deleteContext(sourceContext);
                    RemoveContextAction.this.delete(directory);
                    monitor.done();
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                this.delete(subFile);
                ++n2;
            }
        }
        file.delete();
    }
}

