/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.PageMngrImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalPageMngrImpl
implements IPageMngr {
    private PageMngrImpl pageMngr;
    private TransactionalEditingDomain editingDomain;

    public TransactionalPageMngrImpl(PageMngrImpl pageMngr, TransactionalEditingDomain editingDomain) {
        this.pageMngr = pageMngr;
        this.editingDomain = editingDomain;
    }

    private TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.editingDomain;
    }

    public void addPage(final Object pageIdentifier) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalPageMngrImpl.this.pageMngr.addPage(pageIdentifier);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public List<Object> allPages() {
        return this.pageMngr.allPages();
    }

    public void closePage(final Object pageIdentifier) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalPageMngrImpl.this.pageMngr.closePage(pageIdentifier);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void closeAllOpenedPages() {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalPageMngrImpl.this.pageMngr.closeAllOpenedPages();
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void closeOtherPages(final Object pageIdentifier) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalPageMngrImpl.this.pageMngr.closeOtherPages(pageIdentifier);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void openPage(final Object pageIdentifier) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalPageMngrImpl.this.pageMngr.openPage(pageIdentifier);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void removePage(final Object pageIdentifier) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalPageMngrImpl.this.pageMngr.removePage(pageIdentifier);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public boolean isOpen(Object pageIdentifier) {
        return this.pageMngr.isOpen(pageIdentifier);
    }
}

