/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.extension.commands;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCondition;

public class CreationCommandDescriptor {
    protected Class<? extends ICreationCommand> creationCommandClass;
    protected String commandId;
    protected String label;
    protected ImageDescriptor icon;
    protected String language;
    private ICreationCondition condition;
    protected ICreationCommand instance = null;

    public String getCommandId() {
        return this.commandId;
    }

    public String getLabel() {
        return this.label;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public String getLanguage() {
        return this.language;
    }

    public ICreationCondition getCondition() {
        return this.condition;
    }

    public void setCondition(ICreationCondition condition) {
        this.condition = condition;
        condition.setCommand(this.getCommandId());
    }

    public ICreationCommand getCommand() throws BackboneException {
        if (this.instance == null) {
            this.instance = this.createCommand();
        }
        return this.instance;
    }

    private ICreationCommand createCommand() throws BackboneException {
        try {
            ICreationCommand command = this.creationCommandClass.newInstance();
            return command;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

