/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.lifecycleevents;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.core.lifecycleevents.IEditorInputChangedListener;
import org.eclipse.papyrus.infra.core.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.infra.core.lifecycleevents.LifeCycleEventsProvider;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class SaveAndDirtyService
extends LifeCycleEventsProvider
implements ISaveablePart,
IService,
ISaveAndDirtyService {
    protected LifeCycleEventsProvider lifeCycleEventsProvider = this;
    protected DoSaveEvent lifeCycleEvent;
    private ModelSet resourceSet;
    private TransactionalEditingDomain transactionalEditingDomain;
    private IMultiDiagramEditor multiDiagramEditor;
    private ISaveablePartList registeredIsaveablePart;
    private List<IEditorInputChangedListener> inputChangedListeners;
    private final CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            SaveAndDirtyService.this.fireIsDirtyChanged();
        }
    };
    private final ResourceSetListener resourceSetListener = new ResourceSetListener(){

        public NotificationFilter getFilter() {
            return null;
        }

        public boolean isAggregatePrecommitListener() {
            return false;
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public boolean isPrecommitOnly() {
            return false;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            if (event.getTransaction() != null && event.getTransaction().getStatus().isOK()) {
                SaveAndDirtyService.this.fireIsDirtyChanged();
            }
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            return null;
        }
    };

    public SaveAndDirtyService() {
        this.registeredIsaveablePart = new ISaveablePartList();
        this.inputChangedListeners = new ArrayList<IEditorInputChangedListener>();
    }

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.resourceSet = servicesRegistry.getService(ModelSet.class);
        this.multiDiagramEditor = servicesRegistry.getService(IMultiDiagramEditor.class);
        this.transactionalEditingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain(servicesRegistry);
        this.lifeCycleEvent = new DoSaveEvent(servicesRegistry, this.multiDiagramEditor);
    }

    public void startService() throws ServiceException {
        this.transactionalEditingDomain.getCommandStack().addCommandStackListener(this.commandStackListener);
        this.transactionalEditingDomain.addResourceSetListener(this.resourceSetListener);
    }

    public void disposeService() throws ServiceException {
        if (this.transactionalEditingDomain != null) {
            CommandStack commandStack = this.transactionalEditingDomain.getCommandStack();
            if (commandStack != null) {
                this.transactionalEditingDomain.getCommandStack().removeCommandStackListener(this.commandStackListener);
            }
            this.transactionalEditingDomain.removeResourceSetListener(this.resourceSetListener);
        }
        this.inputChangedListeners.clear();
        this.inputChangedListeners = null;
        this.multiDiagramEditor = null;
        this.transactionalEditingDomain = null;
        this.resourceSet = null;
        this.lifeCycleEvent = null;
        this.postSaveListeners.clear();
        this.saveListeners.clear();
        this.preSaveListeners.clear();
    }

    public void doSave(IProgressMonitor monitor) {
        this.lifeCycleEventsProvider.fireAboutToDoSaveEvent(this.lifeCycleEvent);
        this.lifeCycleEventsProvider.fireDoSaveEvent(this.lifeCycleEvent);
        try {
            this.resourceSet.save(monitor);
            this.registeredIsaveablePart.doSave(monitor);
            this.markSaveLocation();
        }
        catch (IOException e) {
            Activator.log.error("Error during save", (Throwable)e);
        }
        this.lifeCycleEventsProvider.firePostDoSaveEvent(this.lifeCycleEvent);
    }

    public void doSaveAs() {
        this.lifeCycleEventsProvider.fireAboutToDoSaveAsEvent(this.lifeCycleEvent);
        this.lifeCycleEventsProvider.fireDoSaveAsEvent(this.lifeCycleEvent);
        Shell shell = this.multiDiagramEditor.getEditorSite().getWorkbenchWindow().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.multiDiagramEditor.getEditorInput()).getFile());
        dialog.open();
        final IPath path = dialog.getResult();
        if (path != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            try {
                new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        try {
                            EcoreUtil.resolveAll((ResourceSet)SaveAndDirtyService.this.resourceSet);
                            SaveAndDirtyService.this.resourceSet.saveAs(path);
                            SaveAndDirtyService.this.registeredIsaveablePart.doSave(monitor);
                        }
                        catch (IOException e) {
                            Activator.log.error("Unable to saveAs the resource set", (Throwable)e);
                        }
                    }
                });
                this.fireEditorInputChanged(new FileEditorInput(file));
                this.markSaveLocation();
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Activator.log.error((Throwable)e);
            }
        }
        this.lifeCycleEventsProvider.firePostDoSaveAsEvent(this.lifeCycleEvent);
    }

    private void fireEditorInputChanged(FileEditorInput fileEditorInput) {
        for (IEditorInputChangedListener listener : this.inputChangedListeners) {
            try {
                listener.editorInputChanged(fileEditorInput);
            }
            catch (Exception e) {
                Activator.log.error("Can't set input for '" + listener + "'", (Throwable)e);
            }
        }
    }

    private void fireIsDirtyChanged() {
        for (IEditorInputChangedListener listener : this.inputChangedListeners) {
            try {
                listener.isDirtyChanged();
            }
            catch (Exception e) {
                Activator.log.error("Can't call listener '" + listener + "'", (Throwable)e);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.transactionalEditingDomain.getCommandStack()).isSaveNeeded() || this.registeredIsaveablePart.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    protected void markSaveLocation() {
        ((BasicCommandStack)this.transactionalEditingDomain.getCommandStack()).saveIsDone();
        this.fireIsDirtyChanged();
    }

    public void registerIsaveablePart(ISaveablePart saveablePart) {
        this.registeredIsaveablePart.add(saveablePart);
    }

    public void removeIsaveablePart(ISaveablePart saveablePart) {
        this.registeredIsaveablePart.remove(saveablePart);
    }

    public void addInputChangedListener(IEditorInputChangedListener inputChangedListener) {
        this.inputChangedListeners.add(inputChangedListener);
    }

    public void removeInputChangedListener(IEditorInputChangedListener inputChangedListener) {
        this.inputChangedListeners.remove(inputChangedListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ISaveablePartList
    extends ArrayList<ISaveablePart> {
        private static final long serialVersionUID = 1L;

        public boolean isDirty() {
            for (ISaveablePart part : this) {
                if (!part.isDirty()) continue;
                return true;
            }
            return false;
        }

        public void doSave(IProgressMonitor monitor) {
            for (ISaveablePart part : this) {
                try {
                    part.doSave(monitor);
                }
                catch (Exception e) {
                    Activator.log.error("Can't save ISaveablePart '" + part + "'", (Throwable)e);
                }
            }
        }

        public void doSaveAs() {
            for (ISaveablePart part : this) {
                try {
                    part.doSaveAs();
                }
                catch (Exception e) {
                    Activator.log.error("Can't save ISaveablePart '" + part + "'", (Throwable)e);
                }
            }
        }
    }
}

