/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.EditingDomainManager;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.papyrus.infra.core.resource.BadStateException;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelException;
import org.eclipse.papyrus.infra.core.resource.ModelIdentifiers;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.resource.TransactionalEditingDomainManager;
import org.eclipse.papyrus.infra.core.resource.additional.AdditionalResourcesModel;

public class ModelSet
extends ResourceSetImpl {
    public static final String PAPYRUS_EDITING_DOMAIN_ID = "org.eclipse.papyrus.SharedEditingDomainID";
    private Map<String, IModel> models = new HashMap<String, IModel>();
    private ModelSetSnippetList snippets = new ModelSetSnippetList();
    private AdditionalResourcesModel additional = new AdditionalResourcesModel();
    private TransactionalEditingDomain transactionalEditingDomain;
    private IPath filenameWithoutExtension;

    public ModelSet() {
        this.registerModel(this.additional);
        this.setURIResourceMap(new HashMap());
        this.getLoadOptions().put("DEFER_ATTACHMENT", true);
        this.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
    }

    public void registerModel(IModel model) {
        this.models.put(model.getIdentifier(), model);
        model.init(this);
    }

    public IModel getModel(String key) {
        return this.models.get(key);
    }

    public IModel getModelChecked(String key) throws NotFoundException {
        IModel model = this.models.get(key);
        if (model == null) {
            throw new NotFoundException("Can't find model for identifier '" + key + "'.");
        }
        return model;
    }

    public Resource createResource(URI uri, String contentType) {
        return this.setResourceOptions(super.createResource(uri, contentType));
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource resource = null;
        resource = super.getResource(uri, loadOnDemand);
        return this.setResourceOptions(resource);
    }

    public Resource getAssociatedResource(EObject modelElement, String associatedResourceExtension) {
        if (modelElement != null) {
            return this.getAssociatedResource(modelElement.eResource(), associatedResourceExtension);
        }
        return null;
    }

    public Resource getAssociatedResource(Resource modelResource, String associatedResourceExtension) {
        Resource r = null;
        if (modelResource != null) {
            URI trimmedModelURI = modelResource.getURI().trimFileExtension();
            try {
                r = this.getResource(trimmedModelURI.appendFileExtension(associatedResourceExtension), true);
            }
            catch (WrappedException e) {
                if (ModelUtils.isDegradedModeAllowed(e.getCause()) && (r = this.getResource(trimmedModelURI.appendFileExtension(associatedResourceExtension), false)) == null) {
                    throw e;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.setResourceOptions(r);
    }

    protected Resource setResourceOptions(Resource r) {
        ResourceImpl impl;
        if (r instanceof ResourceImpl && (impl = (ResourceImpl)r).getIntrinsicIDToEObjectMap() == null) {
            impl.setIntrinsicIDToEObjectMap(new HashMap());
        }
        return r;
    }

    public TransactionalEditingDomain getTransactionalEditingDomain() {
        this.transactionalEditingDomain = WorkspaceEditingDomainFactory.INSTANCE.getEditingDomain((ResourceSet)this);
        if (this.transactionalEditingDomain == null) {
            this.transactionalEditingDomain = TransactionalEditingDomainManager.createTransactionalEditingDomain((ResourceSet)this);
            EditingDomainManager.getInstance().configureListeners(PAPYRUS_EDITING_DOMAIN_ID, this.transactionalEditingDomain);
        }
        return this.transactionalEditingDomain;
    }

    public IPath getFilenameWithoutExtension() {
        return this.filenameWithoutExtension;
    }

    protected IPath getFilenameWithoutExtensionChecked() throws BadStateException {
        if (this.filenameWithoutExtension == null) {
            throw new BadStateException("Path should be set prior calling any operations.");
        }
        return this.filenameWithoutExtension;
    }

    protected void setFilenameWithoutExtension(IPath filenameWithoutExtension) {
        this.filenameWithoutExtension = filenameWithoutExtension;
    }

    public void createsModels(IFile newFile) {
        this.filenameWithoutExtension = newFile.getFullPath().removeFileExtension();
        for (IModel model : this.models.values()) {
            model.createModel(this.filenameWithoutExtension);
        }
        this.snippets.performStart(this);
    }

    public void createsModels(ModelIdentifiers modelIdentifiers) {
        for (String modelId : modelIdentifiers) {
            IModel model = this.getModel(modelId);
            model.createModel(this.filenameWithoutExtension);
        }
    }

    public IModel loadModel(String modelIdentifier) throws BadStateException {
        IModel model = this.getModel(modelIdentifier);
        model.loadModel(this.getFilenameWithoutExtensionChecked());
        return model;
    }

    @Deprecated
    public IModel loadModel(String modelIdentifier, IFile file) throws ModelException {
        this.importModels(new ModelIdentifiers(modelIdentifier), file);
        return this.getModel(modelIdentifier);
    }

    public void loadModels(IFile file) throws ModelMultiException {
        this.filenameWithoutExtension = file.getFullPath().removeFileExtension();
        ModelMultiException exceptions = null;
        for (IModel model : this.models.values()) {
            try {
                model.loadModel(this.filenameWithoutExtension);
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new ModelMultiException("Problems encountered while loading one of the models.");
                }
                exceptions.addException(model.getIdentifier(), e);
            }
        }
        this.snippets.performStart(this);
        if (exceptions != null) {
            throw exceptions;
        }
    }

    public void importModels(ModelIdentifiers modelIdentifiers, IFile file) throws ModelException {
        IPath path = file.getFullPath().removeFileExtension();
        for (String modelId : modelIdentifiers) {
            IModel model = this.getModel(modelId);
            model.importModel(path);
            if (this.filenameWithoutExtension == null) continue;
            model.changeModelPath(this.filenameWithoutExtension);
        }
    }

    public IModel importModel(String modelIdentifier, IFile file) throws ModelException {
        this.importModels(new ModelIdentifiers(modelIdentifier), file);
        return this.getModel(modelIdentifier);
    }

    public void createMissingModels() throws ModelException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void loadMissingModels() throws ModelException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void save(IProgressMonitor monitor) throws IOException {
        Collection<IModel> modelList = this.models.values();
        monitor.beginTask("Saving resources", modelList.size());
        try {
            for (IModel model : modelList) {
                if (model instanceof AdditionalResourcesModel) continue;
                model.saveModel();
                monitor.worked(1);
            }
            this.additional.saveModel();
        }
        finally {
            monitor.done();
        }
    }

    public void saveAs(IPath path) throws IOException {
        this.filenameWithoutExtension = path.removeFileExtension();
        for (IModel model : this.models.values()) {
            model.changeModelPath(this.filenameWithoutExtension);
        }
        this.save((IProgressMonitor)new NullProgressMonitor());
    }

    public void unload() {
        EList adapters;
        this.snippets.performDispose(this);
        for (IModel model : this.models.values()) {
            if (model instanceof AdditionalResourcesModel) continue;
            model.unload();
        }
        this.additional.unload();
        Iterator iter = this.getResources().iterator();
        while (iter.hasNext()) {
            ((Resource)iter.next()).unload();
            iter.remove();
        }
        if (this.transactionalEditingDomain != null) {
            this.transactionalEditingDomain.dispose();
        }
        if (this.adapterFactories != null) {
            this.adapterFactories.clear();
        }
        if ((adapters = this.eAdapters()) != null) {
            adapters.clear();
        }
    }

    public void addModelSetSnippet(IModelSetSnippet snippet) {
        this.snippets.add(snippet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ModelSetSnippetList
    extends ArrayList<IModelSetSnippet> {
        private static final long serialVersionUID = 1L;

        public void performStart(ModelSet modelsManager) {
            for (IModelSetSnippet snippet : this) {
                snippet.start(modelsManager);
            }
        }

        public void performDispose(ModelSet modelsManager) {
            for (IModelSetSnippet snippet : this) {
                snippet.dispose(modelsManager);
            }
        }
    }
}

