/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource.additional;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelSnippetList;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;

public class AdditionalResourcesModel
implements IModel {
    private ModelSet modelSet;
    private ModelSnippetList snippets = new ModelSnippetList();
    public static String MODEL_ID = "org.eclipse.papyrus.infra.core.resource.additional";

    public void init(ModelSet modelManager) {
        this.modelSet = modelManager;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public void createModel(IPath fullPath) {
    }

    public void loadModel(IPath path) {
        this.snippets.performStart(this);
    }

    public void importModel(IPath fullPathWithoutExtension) {
        this.loadModel(fullPathWithoutExtension);
    }

    public void saveModel() throws IOException {
        for (Resource r : this.modelSet.getResources()) {
            if (!AdditionalResourcesModel.isAdditionalResource(this.getModelManager(), r.getURI()) || this.modelSet.getTransactionalEditingDomain().isReadOnly(r) || !r.getURI().isPlatformResource() && !r.getURI().isFile() || ModelUtils.resourceFailedOnLoad(r)) continue;
            r.save(Collections.EMPTY_MAP);
        }
    }

    public void changeModelPath(IPath fullPath) {
    }

    public void unload() {
        this.snippets.performDispose(this);
        int i = 0;
        while (i < this.modelSet.getResources().size()) {
            Resource next = (Resource)this.modelSet.getResources().get(i);
            if (AdditionalResourcesModel.isAdditionalResource(this.getModelManager(), next.getURI())) {
                next.unload();
            }
            ++i;
        }
    }

    public void addModelSnippet(IModelSnippet snippet) {
        this.snippets.add(snippet);
    }

    protected ModelSet getModelManager() {
        return this.modelSet;
    }

    public static boolean isAdditionalResource(ModelSet modelSet, URI uri) {
        if (uri != null) {
            String platformString = uri.trimFileExtension().toPlatformString(false);
            return platformString == null || !modelSet.getFilenameWithoutExtension().toString().equals(platformString.toString());
        }
        return false;
    }
}

