/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.diagram.common.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.infra.core.resource.notation.NotationUtils;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;

public abstract class CreateDiagramHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain, "Create EMF Diagram"){

            protected void doExecute() {
                CreateDiagramHandler.this.addNewDiagram();
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
        return null;
    }

    protected abstract void addNewDiagram();

    protected void addNewDiagram(String name, String type, EObject diagram) {
        Diagram di2Diagram = NotationFactory.eINSTANCE.createDiagram();
        di2Diagram.setVisible(true);
        di2Diagram.setType(type);
        if (name != null) {
            di2Diagram.setName(name);
        }
        NotationUtils.getNotationModel().addDiagram(di2Diagram);
        EditorUtils.getISashWindowsContentProvider().addPage((Object)di2Diagram);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return EditorUtils.getTransactionalEditingDomain();
    }
}

