/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationApprover2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.internal.command.ICommandWithSettableResult;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;

public class ReadOnlyOneFileApprover
implements IOperationApprover2 {
    public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        return this.proceedExecuting(operation, history, info);
    }

    public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        return this.proceedExecuting(operation, history, info);
    }

    public IStatus proceedExecuting(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        boolean ok;
        HashSet<IFile> filesToCheckForLock = new HashSet<IFile>();
        if (operation instanceof ICommand) {
            ICommand command = (ICommand)operation;
            List affectedFiles = command.getAffectedFiles();
            for (IFile affectedFile : affectedFiles) {
                if (affectedFile == null) continue;
                if (affectedFile.exists()) {
                    IPapyrusFile papFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(affectedFile);
                    filesToCheckForLock.addAll(Arrays.asList(OneFileUtils.getAssociatedFiles((IPapyrusFile)papFile)));
                    continue;
                }
                IPath path = affectedFile.getRawLocation();
                if (path == null) {
                    this.setCommandResult(command, Status.CANCEL_STATUS);
                    return Status.CANCEL_STATUS;
                }
                File file = path.toFile();
                if (file == null || !file.exists() || file.canWrite()) continue;
                this.setCommandResult(command, Status.CANCEL_STATUS);
                return Status.CANCEL_STATUS;
            }
        }
        EditingDomain editingDomain = this.getEditingDomain(operation);
        IFile[] filesToCheckForLockArray = filesToCheckForLock.toArray(new IFile[filesToCheckForLock.size()]);
        if (ReadOnlyManager.isReadOnly(filesToCheckForLock.toArray(filesToCheckForLockArray), editingDomain) && !(ok = ReadOnlyManager.enableWrite(filesToCheckForLockArray, editingDomain))) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected EditingDomain getEditingDomain(IUndoableOperation command) {
        TransactionalEditingDomain editingDomain = null;
        if (command instanceof AbstractEMFOperation) {
            editingDomain = ((AbstractEMFOperation)command).getEditingDomain();
        }
        if (editingDomain == null && command instanceof ICompositeCommand) {
            Iterator it = ((ICompositeCommand)command).iterator();
            while (editingDomain == null && it.hasNext()) {
                IUndoableOperation c = (IUndoableOperation)it.next();
                editingDomain = this.getEditingDomain(c);
            }
        }
        return editingDomain;
    }

    protected void setCommandResult(ICommand command, IStatus status) {
        if (command instanceof ICommandWithSettableResult) {
            ((ICommandWithSettableResult)command).internalSetResult(new CommandResult(status));
        }
    }
}

