/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.emf.providers.strategy.ContainmentBrowseStrategy;
import org.eclipse.papyrus.infra.emf.providers.strategy.StrategyBasedContentProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;

public class ProviderHelper {
    public static EMFGraphicalContentProvider encapsulateProvider(ITreeContentProvider provider, ResourceSet resourceSet, String historyId) {
        ProviderBasedBrowseStrategy browseStrategy = new ProviderBasedBrowseStrategy(provider);
        ContainmentBrowseStrategy revealStrategy = new ContainmentBrowseStrategy(provider);
        StrategyBasedContentProvider strategyProvider = new StrategyBasedContentProvider((TreeBrowseStrategy)browseStrategy, (TreeBrowseStrategy)revealStrategy);
        EMFGraphicalContentProvider graphicalProvider = new EMFGraphicalContentProvider((IStructuredContentProvider)strategyProvider, resourceSet, historyId);
        return graphicalProvider;
    }

    public static EMFGraphicalContentProvider encapsulateProvider(ITreeContentProvider provider, EObject editedEObject, EStructuralFeature feature) {
        ResourceSet rs = editedEObject == null ? null : (editedEObject.eResource() == null ? null : editedEObject.eResource().getResourceSet());
        return ProviderHelper.encapsulateProvider(provider, rs, HistoryUtil.getHistoryID(editedEObject, feature));
    }
}

