/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    private ResourceUtils() {
    }

    public static IFile getFile(Resource resource) {
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                int j = 1;
                int size = uri.segmentCount();
                while (j < size) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(j));
                    ++j;
                }
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            }
        }
        return null;
    }

    public static Collection<String> getAllResourceIds(XMIResource resource) {
        HashSet<String> ids = new HashSet<String>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject current = (EObject)iterator.next();
            String id = resource.getID(current);
            Assert.isNotNull((Object)id);
            Assert.isTrue((!ids.contains(id) ? 1 : 0) != 0);
            ids.add(id);
        }
        return ids;
    }
}

