/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.modelexplorer.handlers;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.gmfdiag.modelexplorer.handlers.AbstractDiagramCommandHandler;

public class DeleteDiagramHandler
extends AbstractDiagramCommandHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        final IPageMngr pageMngr = this.getPageManager();
        List<Diagram> diagrams = this.getSelectedDiagrams();
        if (editingDomain != null && pageMngr != null && !diagrams.isEmpty()) {
            CompoundCommand command = new CompoundCommand();
            for (final Diagram diagram : diagrams) {
                RecordingCommand sashRemoveComd = new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        if (pageMngr.isOpen((Object)diagram)) {
                            pageMngr.closePage((Object)diagram);
                        }
                        pageMngr.removePage((Object)diagram);
                    }
                };
                command.append((Command)sashRemoveComd);
                command.append((Command)new GMFtoEMFCommandWrapper((ICommand)new DestroyElementPapyrusCommand(new DestroyElementRequest((EObject)diagram, false))));
            }
            return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
        }
        return UnexecutableCommand.INSTANCE;
    }
}

