/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.modelelement;

import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.GradientObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.providers.GMFLabelProvider;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableList;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.views.properties.modelelement.EMFModelElement;

public class GMFModelElement
extends EMFModelElement {
    public GMFModelElement(EObject source) {
        super(source);
    }

    public GMFModelElement(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    protected IObservable doGetObservable(String propertyPath) {
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return null;
        }
        if (feature.getEType() == NotationPackage.eINSTANCE.getGradientData()) {
            return new GradientObservableValue(this.source, feature, this.domain);
        }
        if (feature.getUpperBound() != 1) {
            PapyrusObservableList list = this.domain == null ? EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source) : new PapyrusObservableList((List)EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source), this.domain, this.getSource(featurePath), feature);
            return list;
        }
        PapyrusObservableValue value = this.domain == null ? EMFProperties.value((FeaturePath)featurePath).observe((Object)this.source) : new PapyrusObservableValue(this.getSource(featurePath), feature, this.domain);
        return value;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        return new GMFLabelProvider();
    }
}

