/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkEditorHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkEditorHelpersRegistrationUtil {
    private static final String HYPERLINK_EDITOR_HELPER_REGISTRATION_ID = "org.eclipse.papyrus.infra.hyperlink.editor.registration";
    private Collection<AbstractHyperLinkEditorHelper> helpers;
    public static final HyperLinkEditorHelpersRegistrationUtil INSTANCE = new HyperLinkEditorHelpersRegistrationUtil();

    private HyperLinkEditorHelpersRegistrationUtil() {
    }

    public Collection<AbstractHyperLinkEditorHelper> getAllRegisteredHyperLinkEditorHelper() {
        if (this.helpers == null) {
            IConfigurationElement[] config;
            this.helpers = new ArrayList<AbstractHyperLinkEditorHelper>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(HYPERLINK_EDITOR_HELPER_REGISTRATION_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    Object h = e.createExecutableExtension("helper");
                    if (h instanceof AbstractHyperLinkEditorHelper) {
                        this.helpers.add((AbstractHyperLinkEditorHelper)h);
                    } else {
                        Activator.log.info(NLS.bind((String)Messages.HyperLinkEditorHelpersRegistrationUtil_NotAnInstanceOf, (Object[])new Object[]{h, AbstractHyperLinkEditorHelper.class}));
                    }
                }
                catch (CoreException ex) {
                    Activator.log.error(Messages.HyperLinkEditorHelpersRegistrationUtil_ICantCreateTheClassForAnHelper, (Throwable)ex);
                }
                ++n2;
            }
        }
        return this.helpers;
    }
}

