/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.util;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkDocument;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkWeb;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class HyperLinkLabelProvider
implements ILabelProvider {
    protected final String HYPERLINK_WEB_ICON_PATH = "/icons/obj16/hyperlink.gif";
    protected final String HYPERLINK_DOCUMENT_ICON_PATH = "/icons/obj16/file.gif";
    private final String SEP = " - ";
    private IPageIconsRegistry editorRegistry;

    public HyperLinkLabelProvider(IPageIconsRegistry editorFactoryRegistry) {
        this.editorRegistry = editorFactoryRegistry;
    }

    public Image getImage(Object element) {
        if (element instanceof HyperLinkDocument) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/file.gif").createImage();
        }
        if (element instanceof HyperLinkWeb) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/hyperlink.gif").createImage();
        }
        if (element instanceof HyperLinkEditor) {
            return ((HyperLinkEditor)element).getImage(((HyperLinkEditor)element).getObject());
        }
        return null;
    }

    public String getText(Object element) {
        String out = "";
        if (element instanceof HyperLinkDocument) {
            out = ((HyperLinkDocument)element).getHyperlinkDocument();
        } else if (element instanceof HyperLinkWeb) {
            out = ((HyperLinkWeb)element).getHyperLinkWeb();
        } else if (element instanceof HyperLinkEditor) {
            out = ((HyperLinkEditor)element).getText(((HyperLinkEditor)element).getObject());
        } else {
            return null;
        }
        out = String.valueOf(out) + " - " + ((HyperLinkObject)element).getTooltipText();
        return out;
    }

    public String getTooltipText(Object element) {
        return ((HyperLinkObject)element).getTooltipText();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

