/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.decoration.Activator;
import org.eclipse.papyrus.infra.services.decoration.IDecorationService;
import org.eclipse.papyrus.infra.services.decoration.IDecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.DecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.DecorationUtils;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecorationService
extends Observable
implements IDecorationService {
    private ServicesRegistry servicesRegistry;
    private final Map<String, Decoration> decorations = new HashMap<String, Decoration>();

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
    }

    @Override
    public void startService() throws ServiceException {
    }

    @Override
    public void disposeService() throws ServiceException {
    }

    @Override
    public void notifyListeners(DecorationService decorationService) {
        this.setChanged();
        this.notifyObservers(decorationService);
    }

    public ServicesRegistry getServicesRegistry() {
        return this.servicesRegistry;
    }

    public void setServicesRegistry(ServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
    }

    public Map<String, Decoration> getDecorations() {
        return this.decorations;
    }

    @Override
    public synchronized void addListener(Observer o) {
        this.addObserver(o);
    }

    @Override
    public synchronized void deleteListener(Observer o) {
        this.deleteObserver(o);
    }

    @Override
    public void removeDecoration(String id) {
        if (this.decorations.get(id) != null) {
            this.decorations.remove(id);
        }
        this.notifyListeners(this);
    }

    public IPapyrusDecoration addDecoration(IMarker marker, EObject element) {
        try {
            IDecorationSpecificFunctions infoUtil = DecorationSpecificFunctions.getDecorationInterface(marker.getType());
            if (infoUtil != null) {
                ImageDescriptor imageForGE = infoUtil.getImageDescriptorForGE(marker);
                ImageDescriptor imageForME = infoUtil.getImageDescriptorForME(marker);
                Decoration.PreferedPosition position = infoUtil.getPreferedPosition(marker);
                IPapyrusDecoration decoration = this.addDecoration(marker.toString(), marker.getType(), element, imageForGE, imageForME, position, infoUtil.getMessage(marker));
                return decoration;
            }
        }
        catch (CoreException e) {
            Activator.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public IPapyrusDecoration addDecoration(String id, String type, EObject element, ImageDescriptor decorationImageForGE, ImageDescriptor decorationImageForME, Decoration.PreferedPosition position, String message) {
        Decoration decoration = this.decorations.get(id);
        if (decoration == null) {
            decoration = new Decoration(id, type, decorationImageForGE, decorationImageForME, message, element);
            this.decorations.put(id, decoration);
        } else {
            decoration.setDecorationImageForGE(decorationImageForGE);
            decoration.setDecorationImageForME(decorationImageForME);
            decoration.setMessage(message);
        }
        decoration.setPosition(position);
        this.notifyListeners(this);
        return decoration;
    }

    @Override
    public EList<IPapyrusDecoration> getDecorations(Object element, boolean navigateToParents) {
        DecorationUtils tool = new DecorationUtils(element);
        tool.tryChildIfEmpty();
        if (tool.getEObject() != null) {
            return tool.getDecorations(this, navigateToParents);
        }
        return null;
    }
}

