/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation;

import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.services.decoration.IDecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.infra.services.validation.preferences.PreferencePage;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationFunctions
implements IDecorationSpecificFunctions {
    public static final String error_co = "icons/etool16/error_co.gif";
    public static final String warning_co = "icons/etool16/warning_co.gif";
    public static final String info_co = "icons/etool16/info_co.gif";

    public ImageDescriptor getImageDescriptorForGE(IMarker marker) {
        int severity = marker.getAttribute("severity", -1);
        return this.getImageDescriptorForGE(severity);
    }

    public ImageDescriptor getImageDescriptorForGE(int severity) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor overlay = null;
        switch (severity) {
            case 2: {
                overlay = sharedImages.getImageDescriptor("IMG_OBJS_ERROR_TSK");
                break;
            }
            case 1: {
                overlay = sharedImages.getImageDescriptor("IMG_OBJS_WARN_TSK");
                break;
            }
            case 0: {
                overlay = sharedImages.getImageDescriptor("IMG_OBJS_INFO_TSK");
            }
        }
        return overlay;
    }

    public ImageDescriptor getImageDescriptorForME(IMarker marker) {
        int severity = marker.getAttribute("severity", -1);
        return this.getImageDescriptorForME(severity);
    }

    public ImageDescriptor getImageDescriptorForME(int severity) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor overlay = null;
        Activator widgetsActivator = Activator.getDefault();
        switch (severity) {
            case 2: {
                overlay = sharedImages.getImageDescriptor("IMG_DEC_FIELD_ERROR");
                if (overlay != null) break;
                overlay = widgetsActivator.getImageDescriptor("org.eclipse.papyrus.infra.services.validation", error_co);
                break;
            }
            case 1: {
                overlay = sharedImages.getImageDescriptor("IMG_DEC_FIELD_WARNING");
                if (overlay != null) break;
                overlay = widgetsActivator.getImageDescriptor("org.eclipse.papyrus.infra.services.validation", warning_co);
                break;
            }
            case 0: {
                overlay = widgetsActivator.getImageDescriptor("org.eclipse.papyrus.infra.services.validation", info_co);
            }
        }
        return overlay;
    }

    public Decoration.PreferedPosition getPreferedPosition(IMarker marker) {
        return Decoration.PreferedPosition.SOUTH_WEST;
    }

    public String getMessage(IMarker marker) {
        return marker.getAttribute("message", "");
    }

    public IDecorationSpecificFunctions.MarkChildren supportsMarkerPropagation() {
        return PreferencePage.getHierarchicalMarkers();
    }

    public IPapyrusDecoration markerPropagation(EList<IPapyrusDecoration> childDecorations) {
        boolean childWarnings = false;
        boolean childErrors = false;
        for (IPapyrusDecoration childDecoration : childDecorations) {
            if (childDecoration.getDecorationImageForME() == this.getImageDescriptorForME(1)) {
                childWarnings = true;
                continue;
            }
            if (childDecoration.getDecorationImageForME() != this.getImageDescriptorForME(2)) continue;
            childErrors = true;
        }
        if (childWarnings || childErrors) {
            String message = "";
            int childSeverity = 0;
            if (childErrors && childWarnings) {
                message = "Error and warning";
                childSeverity = 2;
            } else if (childErrors) {
                message = "Error";
                childSeverity = 2;
            } else if (childWarnings) {
                message = "Warning";
                childSeverity = 1;
            }
            message = String.valueOf(message) + " marker(s) in one of the children";
            Decoration deco = new Decoration(null, "org.eclipse.emf.ecore.diagnostic", this.getImageDescriptorForGE(childSeverity), this.getImageDescriptorForME(childSeverity), message, null);
            deco.setPosition(Decoration.PreferedPosition.NORTH_WEST);
            return deco;
        }
        return null;
    }
}

