/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.papyrus.infra.services.validation.ValidationUtils;

public class ValidationTool {
    private Object element;
    private EObject eObject;
    private EditingDomain domain;

    public ValidationTool(Object element) {
        this.element = element;
        this.setEObject((EObject)Platform.getAdapterManager().getAdapter(element, EObject.class));
    }

    public ValidationTool(EObject eObject) {
        this.setEObject(eObject);
    }

    public void tryChildIfEmpty() {
        List items;
        if (this.getEObject() == null && this.element instanceof LinkItem && (items = ((LinkItem)this.element).getChildrenElements()).size() > 0 && items.get(0) instanceof EObject) {
            this.setEObject((EObject)items.get(0));
        }
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public void setEObject(EObject eObject) {
        this.eObject = eObject;
    }

    public IMarker[] getMarkers() {
        if (this.getEObject() != null && this.getEObject().eResource() != null) {
            IFile file;
            URI uri = this.getEObject().eResource().getURI();
            String platformResourceString = uri.toPlatformString(true);
            IFile iFile = file = platformResourceString != null ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourceString)) : null;
            if (file != null) {
                try {
                    return file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public EObject eObjectOfMarker(IMarker marker) {
        if (this.getEObject() != null) {
            this.domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getEObject());
            try {
                if (marker.isSubtypeOf("org.eclipse.emf.ecore.diagnostic")) {
                    return ValidationUtils.eObjectFromMarkerOrMap(marker, null, this.domain);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public void deleteSubMarkers() {
        IMarker[] iMarkerArray = this.getMarkers();
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            EObject eObjOfMarker = this.eObjectOfMarker(marker);
            if (this.isContainedBy(eObjOfMarker, this.getEObject())) {
                try {
                    marker.delete();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    private boolean isContainedBy(EObject subEObj, EObject eObj) {
        if (eObj == subEObj) {
            return true;
        }
        if (subEObj != null) {
            return this.isContainedBy(subEObj.eContainer(), eObj);
        }
        return false;
    }
}

