/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.services.validation.ValidationTool;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractValidateCommand
extends AbstractTransactionalCommand {
    protected ValidateAction.EclipseResourcesUtil eclipseResourcesUtil = EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE ? new ValidateAction.EclipseResourcesUtil() : null;
    protected TransactionalEditingDomain domain;
    protected EObject selectedElement;

    public AbstractValidateCommand(String label, TransactionalEditingDomain domain, EObject selectedElement) {
        super(domain, label, Collections.EMPTY_LIST);
        this.domain = domain;
        this.selectedElement = selectedElement;
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        Resource resource = this.getResource();
        if (resource != null) {
            if (this.selectedElement != null) {
                ValidationTool vt = new ValidationTool(this.selectedElement);
                vt.deleteSubMarkers();
            }
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                this.eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
            }
        }
    }

    protected Resource getResource() {
        Resource resource = this.eclipseResourcesUtil != null ? (Resource)this.domain.getResourceSet().getResources().get(0) : null;
        return resource;
    }

    protected void runValidation(final EObject validateElement) {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    final Diagnostic diagnostic = AbstractValidateCommand.this.validate(progressMonitor, validateElement);
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (progressMonitor.isCanceled()) {
                                AbstractValidateCommand.this.handleDiagnostic(Diagnostic.CANCEL_INSTANCE);
                            } else {
                                AbstractValidateCommand.this.handleDiagnostic(diagnostic);
                            }
                        }
                    });
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        if (this.eclipseResourcesUtil != null) {
            runnableWithProgress = this.eclipseResourcesUtil.getWorkspaceModifyOperation(runnableWithProgress);
        }
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnableWithProgress);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
    }

    protected Diagnostic validate(IProgressMonitor progressMonitor, EObject validateElement) {
        int count = 0;
        TreeIterator i = validateElement.eAllContents();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        progressMonitor.beginTask("", count);
        AdapterFactory adapterFactory = this.domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory() : null;
        Diagnostician diagnostician = this.createDiagnostician(adapterFactory, progressMonitor);
        BasicDiagnostic diagnostic = diagnostician.createDefaultDiagnostic(validateElement);
        Map context = diagnostician.createDefaultContext();
        progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(validateElement)}));
        diagnostician.validate(validateElement, (DiagnosticChain)diagnostic, context);
        return diagnostic;
    }

    protected Diagnostician createDiagnostician(final AdapterFactory adapterFactory, final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }

    public boolean canExecute() {
        return this.selectedElement != null;
    }
}

